#ifndef FSMMENU_H
#define FSMMENU_H

#include "mbed.h"


// defines directions as 0/1. Note UPPERCASE
#define menuSTOP 0
#define menuUP 1
#define menuDOWN 2

// set inital state
int state = 0;
int menuDirection = menuSTOP;

// function prototypes
void menuFSM();

void menuFSM() {
    
  // check which state we are in and see which the next state should be next depending on direction
        switch(state) {
            case 0:
                switch(menuDirection) {
                    case menuSTOP:
                        state = 0;
                        break;
                    case menuUP:
                        state = 2;
                        break;
                    case menuDOWN:
                        state = 1;
                        break;
                }
                break;
            case 1:
                switch(menuDirection) {
                    case menuSTOP:
                        state = 1;
                        break;
                    case menuUP:
                        state = 0;
                        break;
                    case menuDOWN:
                        state = 2;
                        break;
                }
                break;
            case 2:
                switch(menuDirection) {
                    case menuSTOP:
                        state = 2;
                        break;
                    case menuUP:
                        state = 1;
                        break;
                    case menuDOWN:
                        state = 0;
                        break;
                }
                break;
            default:  // default case
                //error();  //invalid state - call error routine
                // or could jump to starting state i.e. state = 0
                break;
        }
           
}
    

    
#endif      