
#include "mbed.h"

    Serial LIN(PB_7, PB_6);//lin tx and rx

uint8_t assignID[]={0x55,0x3C, 0x60, 0x06, 0xB1, 0x11, 0x00, 0x00, 0x00, 0x04, 0xD2};// Assign frameID, default NAD used and // ID(PxReq) = 04,ID(PxResp) = 05
uint8_t postiveResp[]={ 0x55,0x7D, 0x60, 0x01, 0xF1, 0xFF, 0xF, 0xFF, 0xFF, 0xFF, 0xAC};// Positive response
uint8_t Datadump1[]={ 0x55, 0x3C, 0x60, 0x01, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAC};//Datadump1, 8 × LSE
uint8_t readdump1[]={0x55, 0x7D, 0x60, 0x06, 0xF4, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xA4};
uint8_t Datadump2[]={ 0x55, 0x3C, 0x60,  0x06, 0xB4, 0x40, 0x00, 0x00, 0x00, 0x00, 0xA4};//Datadump1, 8 × LSE
uint8_t readdump2[]={0x55,0x7D, 0x60,0x06, 0xF4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x64};
uint8_t Datadump3[]={0x55, 0x3C, 0x60,  0x04, 0xB4, 0x80, 0x55, 0x10, 0xFF, 0xFF, 0x01};//Datadump1, 8 × LSE
uint8_t readConfSended[]={0x55,0x7D, 0x60,0x04 , 0xF4, 0x80, 0x55, 0x10, 0xFF, 0xFF, 0xC0};
uint8_t readByID[]={  0x55, 0x3C, 0x60,  0x06, 0xB2, 0x00, 0x11, 0x00, 0x00, 0x00, 0xD5};
uint8_t postiveResp2[]={ 0x55,0x7D, 0x60,  0x06, 0xF2, 0x11, 0x00, 0x00, 0x00, 0x02, 0x93};
uint8_t enbConf[]={0x55,0xC4, 0x01, 0x80, 0x7E};
uint8_t enbP1[] = {0x55,0xC4,0x02 ,0x80, 0x7D};

void sendDataToSlave();
void writeData(uint8_t data[],int length);

int main()
{
    DigitalOut NSLP(PB_5);  //activate lin transiver
    DigitalIn BP(PB_4,PullUp);
    DigitalOut led(PC_13);  //fadding led
    int count =0;
    LIN.baud(19200);
    LIN.format (8,SerialBase::None,1);
    led=1;
    wait(10);
    while (true) {
       
        if(count == 0){
                led=1;
                NSLP=1;
                sendDataToSlave();
                NSLP=0;
                count=1;
            }

    }
}
void sendDataToSlave(){
        writeData(assignID,sizeof(assignID));
        writeData(postiveResp,sizeof(postiveResp));
        writeData(Datadump1,sizeof(Datadump1));
        writeData(readdump1,sizeof(readdump1));
        writeData(Datadump2,sizeof(Datadump2));
        writeData(readdump2,sizeof(readdump2));
        writeData(Datadump3,sizeof(Datadump3));
        writeData(readConfSended,sizeof(readConfSended));
        writeData(readByID,sizeof(readConfSended));
        writeData(postiveResp2,sizeof(postiveResp2));
        writeData(enbConf,sizeof(enbConf));
        writeData(enbP1,sizeof(enbP1));
    }
    
void writeData(uint8_t data[],int length){
        wait_ms(150);//sync break
        LIN.putc(0x80);// sync delimeter
        for(int i =0;i<length;i++){
                LIN.putc(data[i]);
            }
        wait_ms(150);//sync break
    }
