#include "mbed.h"
#include "modem.h"
#include "rtos.h"
#include "math.h"
/* DEFINICION DE PUERTOS */
DigitalOut led1(LED1);
DigitalOut power(PA_13);
DigitalOut sound(PA_14);
/* */
Serial pc(USBTX,USBRX);
char res[32];
Modem modem(PA_11,PA_12,19200);
/*Sortie Digital */
DigitalOut ch1(PC_3);
DigitalOut ch2(PC_2);
DigitalOut ch3(PH_1);
DigitalOut ch4(PH_0);
DigitalOut ch5(PC_15);
DigitalOut ch6(PC_14);
DigitalOut ch7(PC_13);
DigitalOut ch8(PB_7);
/*Entre analogic */
AnalogIn tmp1(PC_0);
AnalogIn tmp2(PC_1);
AnalogIn tmp3(PB_0);
AnalogIn tmp4(PA_4);
AnalogIn tmp5(PA_1);
AnalogIn light(PA_0);
/*variables globales */
int st[8]= {0}; // state de relay
//double ADC[6]= {0}; // sensor temperature et 1 sensor lumiere ADC[5]

int x;
class sim900
{

public:
    int on(void);
    int off(void);
    void speak(int tmp);
    int relay(int rel,int state,int seg);  //1 gsm , 2 gprs
    float read_Temp(int n_sensor);
};

class gprs
{
public:
};

class sms:sim900
{
public:
    int send_m(char *num,char *text);
    int read_m(void);
    int sms_cmd(void);
};

/*definicion de clases*/
int sim900::on()
{
    int i=3;
    i=modem.sendCmdAndWaitForResp("AT\r", "OK", DEFAULT_TIMEOUT,CMD);
    if(i==0) {
        led1=1;
        speak(2);
        return 0;     //ok encendido
    } else {
        power=1;
        wait(0.5);
        power=0;
        wait(3);
        i=modem.sendCmdAndWaitForResp("AT\r", "OK", DEFAULT_TIMEOUT,CMD);
        if(i==0) {
            led1=1;
            speak(2);
        } else {
            led1=0;
            speak(4);
            return -1;
        }
        return 0;
    }

}
int sim900::off()
{
    int i=3;
    i=modem.sendCmdAndWaitForResp("AT\r", "OK", DEFAULT_TIMEOUT,CMD);
    if(i==0) {
        speak(4);
        power=1;
        wait(1);
        power=0;
        led1=0;
        return 0;     //ok encendido
    } else {
        i=modem.sendCmdAndWaitForResp("AT\r", "OK", DEFAULT_TIMEOUT,CMD);
        if(i==0) {
            speak(4);
            power=1;
            wait(1);
            power=0;
            led1=0;
            return 0;     //ok encendido
        } else {
            led1=0;
            speak(4);
        }
        return -1;   // no apagado
    }

}

void sim900::speak(int tmp)
{
    for(int i=0; i<tmp; i++) {
        sound=1;
        wait(0.3);
        sound=0;
        wait(0.3);
    }
}

int sim900::relay(int rel,int state,int seg)
{
    switch (rel) {
        case 1:
            ch1=state;
            break;
        case 2:
            ch2=state;
            break;
        case 3:
            ch3=state;
            break;
        case 4:
            ch4=state;
            break;
        case 5:
            ch5=state;
            break;
        case 6:
            ch6=state;
            break;
        case 7:
            ch7=state;
            break;
        case 8:
            ch8=state;
            break;
    }
    wait(1);
    ch1=0;
    ch2=0;
    ch3=0;
    ch4=0;
    return 0;
}

float sim900::read_Temp(int n_sensor)
{
    double tr,y,temp;
    uint16_t meas=0;
    float Valim=3300;
    float ADCres=65535;
    double Result_V = 0;
    double MinStepRes = 0;

    meas=tmp1.read_u16();

    switch (n_sensor) {
        case 1:
            meas=tmp1.read_u16();
            break;
        case 2:
            meas=tmp2.read_u16();
            break;
        case 3:
            meas=tmp3.read_u16();
            break;
        case 4:
            meas=tmp4.read_u16();
            break;
        case 5:
            meas=tmp5.read_u16();
            break;
        case 6:
            meas=light.read_u16();
            break;
    }
    
    MinStepRes = (Valim / ADCres);
    Result_V = ((MinStepRes * meas))/1000.0;
    tr=(Result_V*47000.0)/(3.3-Result_V);
    y=log(tr/47000.0);
    y=(1.0/298.15)+(y*(1.0/4450.0));
    temp=1.0/y;
    temp=temp-273.15;
    pc.printf("Temp=%f\r\n",temp);
 return temp;
}

int sms::send_m(char *num,char *text)
{
    char aux_string[22]= {0};
    int answer;
    modem.sendCmd("AT+CMGF=1\r");
    wait(1);
    sprintf(aux_string,"AT+CMGS=\"%s\"\r",num);
    modem.sendCmd(aux_string);
    wait(1);
    modem.sendCmd(text);
    wait(1);
    answer=modem.sendCmdAndWaitForResp("\x1A", "OK", DEFAULT_TIMEOUT,CMD);
    if(answer==0) {
        pc.printf("message envoye");
    } else {
        pc.printf("erreur ctrl z");
    }
    return 0;
}



int sms::read_m()
{
    char m[200]= {0};
    char *p;
    char CH1[5]= {0},CH2[5]= {0},CH3[5]= {0},CH4[5]= {0},CH5[5]= {0},CH6[5]= {0},CH7[5]= {0},CH8[1]= {0};
    char phone_number[]="+33000000000";
    int r;
    r=modem.sendCmdAndWaitForResp("AT+CMGR=1\r","+CMGR:",DEFAULT_TIMEOUT,CMD);
    if(r==0) {
        modem.readBuffer(m,200,1);   // leer buffer y guardar en array m[].
        if(NULL!=(p=strstr(m,"+33"))) {
            strncpy(phone_number,p,12);
            pc.puts(phone_number);
        }

        if(NULL!=(p=strstr(m,"CH1="))) {
            strncpy(CH1,p+4,1);
            st[0]=atoi(CH1);
            relay(1,st[0],1);
            pc.puts(CH1);
        }

        if(NULL!=(p=strstr(m,"CH2="))) {
            strncpy(CH2,p+4,1);
            st[1]=atoi(CH2);
            relay(2,st[1],1);
            pc.puts(CH2);
        }
        if(NULL!=(p=strstr(m,"CH3="))) {
            strncpy(CH3,p+4,1);
            st[2]=atoi(CH3);
            relay(3,st[2],1);
            pc.puts(CH3);
        }
        if(NULL!=(p=strstr(m,"CH4="))) {
            strncpy(CH4,p+4,1);
            st[3]=atoi(CH4);
            relay(4,st[3],1);
            pc.puts(CH4);
        }
        if(NULL!=(p=strstr(m,"CH5="))) {
            strncpy(CH5,p+4,1);
            st[4]=atoi(CH5);
            relay(5,st[0],1);
            pc.puts(CH5);
        }
        if(NULL!=(p=strstr(m,"CH6="))) {
            strncpy(CH6,p+4,1);
            st[5]=atoi(CH6);
            relay(6,st[5],1);
            pc.puts(CH6);
        }
        if(NULL!=(p=strstr(m,"CH7="))) {
            strncpy(CH7,p+4,1);
            st[6]=atoi(CH7);
            relay(7,st[6],1);
            pc.puts(CH7);
        }
        if(NULL!=(p=strstr(m,"CH8="))) {
            strncpy(CH8,p+4,1);
            st[7]=atoi(CH8);
            relay(8,st[7],1);
            pc.puts(CH8);
        }
        modem.sendCmd("AT+CMGD=1\r");
        send_m(phone_number,"comando recibido\r");
        modem.cleanBuffer(m,200);
    }
    //pc.printf("%s",m);
    return 0;
}

int main()
{
    sim900 sim;
    // float temperatura;
    sms sms1;
    modem.sendCmd("AT+CNMI=3,1,0,0\r");
    modem.sendCmd("AT+ECHO\r");
    x=sim.on();
    pc.printf("%d",x);
    while(true) {
        sms1.read_m();
        sim.read_Temp(2);
        wait(1);
    }
    //x=sim.off();
    //pc.printf("%d",x);

}