#ifndef TMP007_DEFS_H
#define TMP007_DEFS_H

// Constants for calculating object temperature
#define TMP007_B0       -0.0000294
#define TMP007_B1       -0.00000057
#define TMP007_B2       0.00000000463
#define TMP007_C2       13.4
#define TMP007_TREF     298.15
#define TMP007_A2       -0.00001678
#define TMP007_A1       0.00175
#define TMP007_S0       6.4  // * 10^-14
 
// Configuration Settings
#define TMP007_CFG_RESET         0x8000
#define TMP007_CFG_MODEON        0x1000
#define TMP007_CFG_1SAMPLE       0x0000
#define TMP007_CFG_2SAMPLE       0x0200
#define TMP007_CFG_4SAMPLE       0x0400
#define TMP007_CFG_8SAMPLE       0x0600
#define TMP007_CFG_16SAMPLE      0x0800
#define TMP007_CFG_1SAMPLE_LPWR  0x0a00
#define TMP007_CFG_2SAMPLE_LPWR  0x0c00
#define TMP007_CFG_4SAMPLE_LPWR  0x0e00
#define TMP007_CFG_ALRTEN        0x0100
#define TMP007_CFG_ALLRTF        0x0080
#define TMP007_CFG_TC            0x0040
#define TMP007_CFG_INT_COMP      0x0020

// Status Mask 
#define TMP007_ALRTEN            0x8000
#define TMP007_CRTEN             0x4000
#define TMP007_OHEN              0x2000
#define TMP007_OLEN              0x1000
#define TMP007_LHEN              0x0800
#define TMP007_LLEN              0x0400
#define TMP007_DVEN              0x0200
#define TMP007_MEM_C_EN          0x0100
 
// Registers to read thermopile voltage and sensor temperature
#define TMP007_SENSOR_VOLT         0x00  //RO
#define TMP007_LOCAL_TEMP          0x01  //RO
#define TMP007_CONFIG              0x02  //RW
#define TMP007_OBJECT_TEMP         0x03  //RO
#define TMP007_STATUS              0x04  //RO
#define TMP007_STATUS_MASK         0x05  //RW

#define TMP007_OBJECT_TEMP_HI_LIM  0x06  //RW
#define TMP007_OBJECT_TEMP_LO_LIM  0x07  //RW
#define TMP007_LOCAL_TEMP_HI_LIM   0x08  //RW
#define TMP007_LOCAL_TEMP_LO_LIM   0x09  //RW

#define TMP007_COEFFICIENT_S0      0x0a  //RW
#define TMP007_COEFFICIENT_A1      0x0b  //RW
#define TMP007_COEFFICIENT_A2      0x0c  //RW
#define TMP007_COEFFICIENT_B0      0x0d  //RW
#define TMP007_COEFFICIENT_B1      0x0e  //RW
#define TMP007_COEFFICIENT_B2      0x0f  //RW
#define TMP007_COEFFICIENT_C2      0x10  //RW
#define TMP007_COEFFICIENT_TC0     0x11  //RW
#define TMP007_COEFFICIENT_TC1     0x12  //RW

#define TMP007_MANUFACTURE_ID      0x1E  //RO
#define TMP007_DEVICE_ID           0x1F  //RO
#define TMP007_MEM_ACCESS          0x2A  //RW

#endif // TMP007_DEFS_H