#ifndef __LINE_H_
#define __LINE_H_

#include "Point.h"

template <class T>
class Line {
    
public:
    Line():
    _x1(0),
    _y1(0),
    _x2(0),
    _y2(0)
    {}
    
    Line(T x1, T y1, T x2, T y2):
    _x1(x1),
    _y1(y1),
    _x2(x2),
    _y2(y2)
    {}
    
    Point<T> p1() const {return Point(_x1, _y1);}
    Point<T> p2() const {return Point(_x2, _y2);}
    void setP1(T x, T y){_x1 = x; _y1 = y;}
    void setP2(T x, T y){_x2 = x; _y2 = y;}
      
    bool isNull() const {return (_x1 == 0 && _y1 == 0 && _x2 == 0 && _y2 == 0);}
    
    friend inline bool operator==(const Line &l1, const Line<T> &l2){return (l1._x1==l2._x1 && l1._x2==l2._x2 && l1._y1==l2._y1 && l1._y2==l2._y2);}
    friend inline bool operator!=(const Line &l1, const Line<T> &l2){return (l1._x1!=l2._x1 || l1._x2!=l2._x2 || l1._y1!=l2._y1 || l1._y2!=l2._y2);}
    
    bool contains(const Point<T> &p) const
    {
        T l = xp;
        T r = xp;
        if (w < 0)
            l += w;
        else
            r += w;
        if (l == r) // null rect
            return false;
    
        if (p.x() < l || p.x() > r)
            return false;
    
        T t = yp;
        T b = yp;
        if (h < 0)
            t += h;
        else
            b += h;
        if (t == b) // null rect
            return false;
    
        if (p.y() < t || p.y() > b)
            return false;
    
        return true;
    }
    
private:
    T _x1; 
    T _y1; 
    T _x2;
    T _y2;
};


#endif // __LINE_H_