#include "pong.h"
using namespace std;

pong::pong()
{
    lcd = new NokiaLCD(p5, p7, p8, p9, NokiaLCD::LCD6610);
    //for all dimensions: x, y, width, height
    ball[0] = 65; ball[1] = 65; ball[2] = 3; ball[3] = 3;
    ballDir[0] = -1; ballDir[1] = 1;
    rightPaddle[0] = 10; rightPaddle[1] = 55; rightPaddle[2] = 5; rightPaddle[3] = 20;
    leftPaddle[0] = 115; leftPaddle[1] = 55; leftPaddle[2] = 5; leftPaddle[3] = 20;
    score[0] = 0; score[1] = 0;
    
}

void pong::drawObjects()
{
    lcd->background(0x000000);
    lcd->fill(leftPaddle[0], leftPaddle[1], leftPaddle[2], leftPaddle[3], 0xFFFFFF);
    lcd->fill(rightPaddle[0], rightPaddle[1], rightPaddle[2], rightPaddle[3], 0xFFFFFF);
    lcd->fill(ball[0], ball[1], ball[2], ball[3], 0xFFFFFF);
}

void pong::update(double left, double right)
{
    leftPaddle[1] = left * 110;
    rightPaddle[1] = right * 110;
    
    //right paddle collision check -- reverse if true
    if ( (ball[0] + ball[2] -1 + ballDir[0]) == leftPaddle[0] ) {
        if ( ( (ball[1] + ball[3]-1 + ballDir[1]) >= leftPaddle[1] ) && ( (ball[1] + ballDir[1]) <= (leftPaddle[1] + leftPaddle[3]-1) ) )
            ballDir[0] = -1;
    }
    
    //left paddle collision check -- reverse if true
    if ( (ball[0] + ballDir[0]) == (rightPaddle[0] + rightPaddle[2]-1) ) {
        if ( ( (ball[1] + ball[3]-1 + ballDir[1]) >= rightPaddle[1] ) && ( (ball[1] + ballDir[1]) <= (rightPaddle[1] + rightPaddle[3]-1) ) )
            ballDir[0] = 1;
    }
    
    ball[0] = ball[0] + ballDir[0];
    ball[1] = ball[1] + ballDir[1];
    
    //if the ball hits the left wall, increment right player's score and reset
    if ( ball[0] == 0 )
    {
        score[1]++;
        ball[0] = 65; ball[1] = 65; ball[2] = 3; ball[3] = 3;
        ballDir[0] = -1; ballDir[1] = 1;
    }
     //if the ball hits the right wall, increment left player's score and reset
    else if ( (ball[0] + ball[2]-1) == 130 )
    {
        score[0]++;
        ball[0] = 65; ball[1] = 65; ball[2] = 3; ball[3] = 3;
        ballDir[0] = 1; ballDir[1] = 1;
    } 
    
    if ( (ball[1] + 2 == 130) && (ballDir[1] == 1) ) ballDir[1] = -1;
    else if ( (ball[1] - 1 == 0) && (ballDir[1] == -1) ) ballDir[1] = 1;
    
}

void pong::clear()
{
    lcd->fill(leftPaddle[0], leftPaddle[1], leftPaddle[2], leftPaddle[3], 0x000000);
    lcd->fill(rightPaddle[0], rightPaddle[1], rightPaddle[2], rightPaddle[3], 0x000000);
    lcd->fill(ball[0], ball[1], ball[2], ball[3], 0x000000);
}