#include "mbed.h"
#include "LM75B.h"
#include "SDFileSystem.h"

LM75B tmp(p28,p27);
DigitalOut indicateur(LED1);
Serial pc(USBTX, USBRX);

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

int main()
{
    indicateur = 1;
    pc.printf("Hello World!\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    for (int i = 0; i<10; i++) {
        fprintf(fp, "La temperature est = %.2f C",tmp.read());
        wait(0.1);
    }
    fprintf(fp, "FIN");
    fclose(fp);

    printf("Goodbye World!\n");
    while (1) {
        indicateur =0;
        wait(0.50);
        indicateur =1;
        wait(0.50);
    }
}
