#include "mbed.h"
#include "USBSerial.h"
#include <iostream>
#include <string>

//sending data example
//https://developer.mbed.org/forum/helloworld/topic/2579/

//Outgoing comm from board to chip
Serial micro(p9, p10);//tx, rx
//Virtual serial port over USB
Serial pc(USBTX, USBRX);
 
int main(void) {
    pc.printf("%s", "connected...\n");
    //config for outgoing comm
    micro.format(8, Serial::None, 1);
    micro.baud(9600); //maybe back down to 9600
    
    int word_size = 0;
    uint8_t arr[50];
    while(1){
        for(int i = 0; i < 50; i++)
        {
         
                arr[i] = pc.getc();
                pc.putc(arr[i]);
                word_size += 1;
                if(arr[i] == '.'){break;}
        }
        for(int i = 0; i < word_size; i++)
        {
                if(micro.writeable()){
                    micro.printf("%c", arr[i]);
                }
                pc.printf("%c", arr[i]);
        }
        pc.printf("\n");
        
        word_size = 0;
    }
    
}