// provided by znrobotics.
#include "mbed.h"
#include "SDFileSystem.h"
#include "WIZnetInterface.h"
#include "HTTPClient.h"
#include "DHT22.h"

#define USE_DHCP 1
#define LOOPBACKPORT  5000

const int USE_HTTP_PROTOCAL = 1;
const int USE_COAP_PROTOCAL = 2;
const int USE_MQTT_PROTOCAL = 3;

int W5500_Test(void);

float* temperature_get();         /* Grove - Temperature Sensor V1.2 */
float th[2];

SPI spi(SPI_PSELMOSI0, SPI_PSELMISO0, SPI_PSELSCK0);
WIZnetInterface ethernet(&spi, p24, p17); // Spi ,cs, reset
int ret, dummy, lv = 1;

const char* http_port = "80";
const char* coap_port = "5683";
const char* mqtt_port = "1883";

// todo:: your settings here.
//const char * SERVER_REMOTE = "58.214.20.195";
const char * SERVER_REMOTE = "52.76.14.222";
const char * IP_Addr      = "192.168.1.223";
const char * IP_Subnet    = "255.255.255.0";
const char * IP_Gateway   = "192.168.1.1";
const char * DEVICE_ID    = "1570f165-89ca-4fdf-a625-86736c8afd23";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x1C,0xAA,0xCA};
// which protocal to use
// 1 => HTTP; 
// 2 => CoAP;
// 3 => MQTT
const int PROTOCAL_INUSE  = 1;
// unit: seconds;
const int time_interval   = 60; //seconds

// timer event;
Ticker flipper;
void timer_ticked();

DigitalOut myled(LED1);
//Arch Link
Serial pc(USBTX, USBRX);  /* uart */
DHT22 dht22(p6);

AnalogIn   ain(A0);

int main() {
    wait(1);
    pc.baud(9600);
    wait(1);
    
    if(W5500_Test() == 0) {                  // Internet is ok
        printf("W5500 tested OK \r\n");
        
        // start timer tick event.
        flipper.attach(&timer_ticked, time_interval);
    }
    
    while(1) {
        myled = !myled;
        wait(10);
    }
}

void timer_ticked()
{
    char str[512];
    char get_msg[512]= "";
    
    float* th = temperature_get();
    printf("temperature: %.2f -- Humidity: %.2f.\r\n",th[0], th[1]);
    
    pc.printf("posting message to znrobotics server.\r\n");
    
    switch (PROTOCAL_INUSE)
    {
        case USE_HTTP_PROTOCAL:
        {
            HTTPClient http;
            
            sprintf(get_msg, "http://%s/sensors/things?deviceid=%s&temperature=%.2f", SERVER_REMOTE, DEVICE_ID, th[0]);
            pc.printf("msg : %s\r\n",get_msg);
            ret = http.get(get_msg, str, sizeof(str));
            if(!ret)
            {
                pc.printf("Response fetched successfully - read %d characters\r\n", strlen(str));
                pc.printf("Result: %s\r\n", str);
            }
            else
            {
                pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
            
            sprintf(get_msg, "http://%s/sensors/things?deviceid=%s&humidity=%.2f", SERVER_REMOTE, DEVICE_ID, th[1]);
            pc.printf("msg : %s\r\n",get_msg);
            ret = http.get(get_msg, str, sizeof(str));
            if(!ret)
            {
                pc.printf("Response fetched successfully - read %d characters\r\n", strlen(str));
                pc.printf("Result: %s\r\n", str);
            }
            else
            {
                pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
        }
        break;
        case USE_COAP_PROTOCAL:
        {
            
        }
        break;
        case USE_MQTT_PROTOCAL:
        {
            
        }
        break;
    }
    
    pc.printf("\n");
}

int W5500_Test(void)
{
    mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    wait(1);
    printf("Start to test ethernet!\r\n");
    
    #if USE_DHCP
    printf("use DHCP\r\n");
    ret = ethernet.init(MAC_Addr);
    #else
    printf("do NOT use DHCP\r\n");
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    
    if (!ret) {
        pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            pc.printf("IP: %s, MASK: %s, GW: %s\r\n", ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            return 0;
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            //exit(0);
            return -1;
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        //exit(0);
        return -1;
    }
}

float* temperature_get()
{
    int error = 0;
    
    float temp, hum;
    
    error = dht22.sample();
    
    // read successfully
    if (1 == error) {
        // YOUR CODE GOES HERE, read temperature and humidity
        temp    = dht22.getTemperature()/10.0f; //TODO;
        hum     = dht22.getHumidity()/10.0f;  //TODO;
        th[0]   = temp;
        th[1]   = hum;
    // printf("temp: %2.2f  , hum:%2.2f    \r\n",temp,hum);
    } else {
        printf("Error: %d\n", error);
    }
            
    return th;
}