#include "mbed.h"
#include "SLCD.h"


#define PROGNAME "lightsense_kl46z_basic v1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define LEDON false
#define LEDOFF true
#define LRED "RED"
#define LGREEN "GREN"

SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;
Timer LIGHTTimer;

bool ledState = LEDON;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    char lcdData[LCDLEN];
   
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity  
            sprintf(lcdData,"%4.3f",lightData);       
            LCDMess(lcdData);  
            timeToChangeDF = DATATIME;
            gled = 0.0;
            rled = 0.0;
            LEDTimer.reset();
        } 
    }// emd while
}
