#include "mbed.h"

/** Seeed Studio Shield Bot Control Class
 *  In order to use this properly, you need to connect a jumper between pins eight and three on the shield bot, and you can't use either pins 8 or 3, which correspond to PTA13 and PTA12, respectively.
 *  Also, in order to provide power to the freedom board, when running just of a lipo battery, you need to connect between 5V and VIN on the shield bot.
 *  Code/notes above only tested with version 0.9b, may not be needed/may not work in other cases...
*/
class SeeedStudioShieldBot {
    public:
    
        // Create a shield bot object, using default settings for now...
        SeeedStudioShieldBot();
        
        /** Switch on the left motor at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
        */
        void left_motor(float speed);
        
        /** Switch on the right motor at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
        */
        void right_motor(float speed);
        
        /** Switch on both motors, forwards at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
        */
        void forward(float speed);
        
        /** Switch on both motors, backwards at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
        */
        void backward(float speed);
        
        /** Switch on both motors at the given speed, in opposite directions so as to turn left.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motors.
        */
        void left(float speed);
        
        /** Switch on both motors at the given speed, in opposite directions so as to turn right.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motors.
        */
        void right(float speed);

        /** Disable the left motor, by driving enable pin for the second motor low...
        */
        void disable_left_motor();
        
        /** Disable the left motor, by driving enable pin for the first motor low...
        */
        void disable_right_motor();
        
        /** Enable the left motor, by driving enable pin for the second motor high...
        */
        void enable_left_motor();
        
        /** Enable the left motor, by driving enable pin for the first motor high...
        */
        void enable_right_motor();
        
        /** Stop both motors at the same time. Different to disable.
        */
        void stopAll();
        
        /** Stop a chosen motor.
         *  @param motor Number, either 1 or 2 choosing the motor.
        */
        void stop(int motor);
        
        // Need to do something to do with detected line...
        
        /** Gives an indication of the data given by the reflectivity sensors.
        */
        float line_position();
        
        DigitalIn rightSensor;
        DigitalIn inRightSensor;
        DigitalIn centreSensor;
        DigitalIn inLeftSensor;
        DigitalIn leftSensor;
        
    private:
        PwmOut motor1A;
        DigitalOut motor1B;
        DigitalOut motor1En;
        
        // motor2A or motor2B need to be PWM, but the freedom board doesn't support it at the moment...
        PwmOut motor2A;
        DigitalOut motor2B;
        DigitalOut motor2En;
};