#include "mbed.h"

AnalogOut testAnalog(p18);
InterruptIn control(p21);
Serial target (p28,p27);
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
float value = 0;

void goUp() {
    value += 0.1;
    testAnalog.write(value);
    printf("Value: %.2f\r\n", value);
    
    if (value >= 1.00f) {
        value = 0;
    }
    
    while (control.read() == 1);
}

int main() {
    target.baud(9600);
    testAnalog.write(0);
    control.rise(&goUp);
    
    printf("Ready. \r\n");
    
    while(1) {
        if (pc.readable()) {
            target.putc(pc.getc());
            led1 = !led1;
        }
 
        if (target.readable()) {
            pc.putc(target.getc());
            led2 = !led2;
        }
    }
}
