#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "Thread.h"
#include "rtos.h"



LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
Mutex stdio_mutex;
uint8_t r=0,g=0,b=0;





class DRAW            //クラス宣言
{
private:
    uint32_t color;
    uint16_t Xpos;
    uint16_t Ypos;
    uint16_t Rad;
public:
    void fillcircle(uint32_t col,uint16_t x,uint16_t y,uint16_t rad);
};


void DRAW::fillcircle(uint32_t col,uint16_t x,uint16_t y,uint16_t rad){
    lcd.SetTextColor(col|0xFF000000);
    lcd.FillCircle(x,y,rad);
}


DRAW draw;

void lcd_r_thread(void const *args) {
    while (true) {
        stdio_mutex.lock();
        draw.fillcircle(r*0x00010000,100,150,30);
        stdio_mutex.unlock();
        r++;
        Thread::wait(20);
    }
}
void lcd_g_thread(void const *args) {
    while (true) {
        stdio_mutex.lock();
        draw.fillcircle(g*0x00000100,200,150,30);
        stdio_mutex.unlock();
        g++;
        Thread::wait(40);
    }
}
void lcd_b_thread(void const *args) {
    while (true) {
        stdio_mutex.lock();
        draw.fillcircle(b,300,150,30);
        stdio_mutex.unlock();
        b++;
        Thread::wait(60);
    }
}
void RGBtext(void const *args) {
    uint8_t text[30];
    while (true) {
        stdio_mutex.lock();
        lcd.SetFont(&Font24);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)text, "R:0x%x",r);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "G:0x%x",g);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "B:0x%x",b);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);
        stdio_mutex.unlock();
        Thread::wait(100);
    }
}
void TPtext(void const *args) {
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    while (true) {
        stdio_mutex.lock();
        lcd.SetFont(&Font12);
        lcd.SetTextColor(LCD_COLOR_WHITE);

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(150, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(150, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }

            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLACK);
                sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(150, LINE(0), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }        
        stdio_mutex.unlock();
        Thread::wait(1);
    }
}




int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    
//    RtosTimer lcd_r_timer(fillcircle, osTimerPeriodic, (void *)0);
//    RtosTimer lcd_r_timer(fillcircle(r*0x00010000,100,150,30), osTimerPeriodic);


    

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    wait(1);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    wait(1);
    lcd.SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    
//    thread.start(lcd, color_cng);
//    Thread::wait(5000);
//    running = false;
//    thread.join();

//    lcd_r_timer.start(100);
    Thread thread1(lcd_r_thread);
    Thread thread2(lcd_g_thread);
    Thread thread3(lcd_b_thread);
    Thread thread4(RGBtext);
    Thread thread5(TPtext);
    
    while(1) {
        
/*        
        lcd.SetTextColor(r*0x00010000|0xFF000000);
        lcd.FillCircle(100,150,100);
        lcd.SetTextColor(g*0x00000100|0xFF000000);
        lcd.FillCircle(200,150,100);
        lcd.SetTextColor(b|0xFF000000);
        lcd.FillCircle(300,150,100);
*/
//        draw.fillcircle(r*0x00010000,100,150,30);
//        lcd.SetTextColor(r*0x00010000|0xFF000000);
//        lcd.FillCircle(100,150,30);
//        lcd.SetTextColor(g*0x00000100|0xFF000000);
//        lcd.FillCircle(200,150,30);
//        lcd.SetTextColor(b|0xFF000000);
//        lcd.FillCircle(300,150,30);
/*
        lcd.SetFont(&Font24);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)text, "R:0x%x",r);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "G:0x%x",g);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "B:0x%x",b);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);
*/
/*        lcd.SetFont(&Font12);
//        lcd.SetBackColor(~col|0xFF000000);
//        lcd.SetTextColor(col|0xFF000000);

        
        
        
        
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(150, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(150, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }

            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLACK);
                sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(150, LINE(0), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }*/
    }
}


