#include "TimerDevice.hpp"

//Constructor
TimerDevice::TimerDevice(LineData lineData){
    //No Constructor needed... functionality already exists in mBed library
}


//A line consists of [ __(Local_Name)__ __(function)__ __(parameter1)__ __(parameter2)__ __(parameter3)__ ... and so on]
int TimerDevice::interpret(LineData &lineData){


            
    //Order of line: local_name, function_name, param1, param2, param3,.......
    string func = lineData.word[1];

    /******************************************************************************/
    /***                          <func: start>                                 ***/
    /******************************************************************************/
    if (func.compare("start") == 0){
        
        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        this->Timer.start();
    }
    
    
    /******************************************************************************/
    /***                           <func: stop>                                 ***/
    /******************************************************************************/
    else if (func.compare("stop") == 0){
    
        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        this->Timer.stop();
    }
    
    /******************************************************************************/
    /***                          <func: reset>                                 ***/
    /******************************************************************************/
    else if (func.compare("reset") == 0){
  
        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }

        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
              
        this->Timer.stop();
        this->Timer.reset();            
        this->Timer.start();
    }
    
    /******************************************************************************/
    /****                           <func: val>                                ****/
    /******************************************************************************/
    else if (func.compare("val") == 0){

        //line looks like: local_name, val, comparison_characteristics (<, >, =)
        if (lineData.numWords != 4){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        string cmpChar = lineData.word[2];  //Get the comparison characteristic value
        
        string timestr = lineData.word[3];  //Parameter is a number
        int timeValue = 0;                  //Time value to compare in ms
        int numValuesFound = sscanf(timestr.c_str(), "%d", &timeValue);
        if (numValuesFound < 1){
            ErrorOut("Parameter Unknown,  time value can't be converted", lineData.lineNumber);
            return -1;
        }

        //Error check comparision characteristic
        if (cmpChar.compare("<") != 0 && cmpChar.compare(">") != 0 && cmpChar.compare("=") != 0){
            ErrorOut("Parameter Unknown,  comparison character can't be converted", lineData.lineNumber);
            return -1;
        }

        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        if (cmpChar.compare("<") == 0){
            if (this->Timer.read_ms() < timeValue)
                return 1; //met condition
        }
        else if (cmpChar.compare(">") == 0){
            if (this->Timer.read_ms() > timeValue)
                return 1; //met condition
        }
        else if (cmpChar.compare("=") == 0){
            if (this->Timer.read_ms() == timeValue)
                return 1; //met condition
        }
        
    }
    
    
    else {
        ErrorOut("Unknown Command for Voltage Driver Class", lineData.lineNumber);
        return -1;
    }  
            
    return 0; //Return success as 0 since no condition had to be met
}


//For stopping the entire system if an error occurs, can be called from main
int TimerDevice::off(void){
    this->Timer.stop();
    return 0;
}


//Pause the timer
int TimerDevice::pause(void){
    this->Timer.stop();
    return 0;
}

//Resume the timer
int TimerDevice::resume(void){
    this->Timer.start();
    return 0;
}

        
