//#include "mainFunctions.hpp"
//
///******************************************************************************/
///***                      <Function: cyclePrograms>                         ***/
///******************************************************************************/
//
//int cyclePrograms(vector<string> files, int SIZE, int currIndex, int direction){
//    
//    int nextIndex = 0;
//    switch(direction){
//        case 0: //Cycle Back one File
//            if ((currIndex - 1) < 0)
//                nextIndex = SIZE - 1;
//            else
//                nextIndex = currIndex - 1;
//            break;
//        case 1: //Cycle Forward one File
//            if ((currIndex + 1) >= SIZE)
//                nextIndex = 0; 
//            else
//                nextIndex = currIndex + 1;
//            break;
//        case -1: //set the selectedFile to the currIndex (used for initialization)
//            nextIndex = currIndex;
//            break;
//    }
//
//    //Output file on Display 
//    lcd.setAddress(0,3);
//    lcd.printf("                   "); // Clear the Line using Spaces (Emptyness) - Note one line is 20 Characters
//    wait(.2);
//    lcd.setAddress(0,3);
//    lcd.printf("%s", files[nextIndex]);
//    
//    return nextIndex; // Return the file index in the Array         
//}
//
///******************************************************************************/
///***                      <Function: resetLineData>                         ***/
///******************************************************************************/
//
//void resetLineData(LineData &lineData){
//    
//    lineData.lineNumber = 0;
//    lineData.numWords = 0;
//    lineData.lineAddress = 0;
//}
//
///******************************************************************************/
///***                    <Function: interpretCommand>                        ***/
///******************************************************************************/
//
//int interpretCommand(FILE *selectedFile, LineData &lineData){
//        
//    if (lineData.word[0].compare("device") == 0){
//
//        int i = 0, deviceFound = -1;
//        for (i = 0; i < numDevices; i++){
//            if (lineData.word[2].compare(DeviceNames[i]) == 0){
//                deviceFound = i;
//            }
//        }
//        
//        //if the device type does not match any known type, error out
//        if (deviceFound == -1){
//            //Error Out since the device Name was not matched with anything *************************   
//        }
//        
//        //Add device to the array of devices and initialize it
//        else{
//            devices.push_back(Device::newDevice(deviceFound, lineData.word[1], lineData));
//            devices.back()->name = lineData.word[1];             
//        }
//    }
//    
//    else if (lineData.word[0].compare("delay") == 0){
//        string duration = lineData.word[1];
//        int durationValue = 0;
//        sscanf(duration.c_str(), "%d", &durationValue);
//        
//        if (durationValue){
//            timer.reset();
//            timer.start();
//            while (timer.read_ms() < durationValue); //Do Nothing while the timer has not reached the duration
//            timer.stop(); //Stop the Timer
//        }
//        else{
//            //Error Out
//            return -1;
//        }
//    }
//    
//    else if (lineData.word[0].compare("loop") == 0){
//        int checkLoopEnd = loopCommand(selectedFile, lineData);
//        if (checkLoopEnd == 1)
//            return 1;
//    }
//       
//    else if (lineData.word[0].compare("condition") == 0){
//        int checkLoopEnd = conditionCommand(selectedFile, lineData);
//        if (checkLoopEnd == 1)
//            return 2;
//    }     
//    // end with custom return value for specific function
//    else if (lineData.word[0].compare("end") == 0){
//        if (lineData.word[1].compare("program") == 0){
//            return 2;
//        }
//        else if (lineData.word[1].compare("loop") == 0){
//            return 3;
//        }
//        else if (lineData.word[1].compare("condition") == 0){
//            return 4;
//        }
//    }
//    
//    //not a keyword so check if it's a localName for a device
//    else{
//    
//        int i = 0, deviceFound = -1;
//        for (i = 0; i < devices.size(); i++){
//            if (lineData.word[0].compare(devices[i]->name) == 0)
//                deviceFound = i;
//        }
//                
//        //no device was found that matched the local name, and this is also the last error check, meaning it can match no other potential keywords
//        if (deviceFound == -1){
//            lcd.setAddress(0,3);
//            lcd.printf("Final ERROR!");
//            wait(10);
//        }
//        
//        //Local Name matches a device, send line to that device in order to process the functionality
//        else{
//            //addDevice(deviceFound);
//            return devices[deviceFound]->interpret(lineData);
//        }
//    }  
//    
//    return -1;
//}
//
///******************************************************************************/
///***                       <Function: loopCommand>                          ***/
///******************************************************************************/
//
//int loopCommand(FILE *selectedFile, LineData &lineData){
//        
//    //Get the Condition value for number of times to loop
//    string loopCondition = lineData.word[1];
//    int loopConditionValue = 0;
//    sscanf(loopCondition.c_str(), "%d", &loopConditionValue);
//    
//    int loopStartAddress = 0, loopLineNumber = 0, firstLineOfLoop = 1;
//        
//    lcd.setAddress(0,0);
//    lcd.printf("Cycle 1 of %d", loopConditionValue);
//        
//    Timer cycleTimer;
//    float totalLoopTime = 0;
//    cycleTimer.reset();
//    cycleTimer.start();
//       
//    int counter = 1, checkEnd = 0;
//    while (counter <= loopConditionValue){
//        
//        getNextLine(selectedFile, lineData); 
//        
//        //Must get the address before entering the interpret command
//        // if a Condition command is immediately after, and the condition fails, then
//        // the interpret command will return the line at the "end condition" line, and therefore
//        // set the loop's first line to be the "end condition" line, if interpretCommand is called BEFORE setting the first loop line address
//        if (firstLineOfLoop){
//            loopStartAddress = lineData.lineAddress; //Save the Line Address
//            loopLineNumber = lineData.lineNumber;    //Save the Line Number
//            firstLineOfLoop = 0;
//        }
//           
//        checkEnd = interpretCommand(selectedFile, lineData);
//
//        //Increase the loop counter and go back to the beginning of the loop
//        if (checkEnd == 3){
//            
//            //Output the Avg Cycle Time
//            cycleTimer.stop(); 
//            totalLoopTime += cycleTimer.read();
//            
//            lcd.setAddress(0,1);
//            lcd.printf("Avg t(sec): %1.3f", (totalLoopTime / counter));
//            
//            //Output Cycle Number
//            counter++;
//            lcd.setAddress(0,0);
//            lcd.printf("Cycle %d of %d", counter, loopConditionValue);
//            
//            fseek(selectedFile, loopStartAddress, SEEK_SET);
//            lineData.lineNumber = loopLineNumber - 2;
//            checkEnd = 0;
//            
//            //Restart the timer for the next loop
//            cycleTimer.reset();
//            cycleTimer.start();
//        }
//    }
//                
//    return 1;
// }   
//
///******************************************************************************/
///***                    <Function: conditionCommand>                        ***/
///******************************************************************************/
//
//int conditionCommand(FILE *selectedFile, LineData &lineData){
//        
//    //Get the number of condition parameters 
//    string numConditionVals = lineData.word[1];
//    int numConditionValues = 0;
//    sscanf(numConditionVals.c_str(), "%d", &numConditionValues);
//    
//    //LineData tempLineData;
//    LineData param[15];
//    //vector<LineData> param;
//    vector<ConditionOp> paramCondition;
// 
//    
//    //Fill the param Vector with Line structs of each individual device, this way we can send the Line struct to the appropriate interpret function without modification within the function itself
//    int i = 2, numParam = 0, paramNumWords = 0;
//    for (i = 2; i < lineData.numWords; i++){
//                       
//        // if the word is not an AND or an OR, it must mean it's for the specific function
//        // set the current parameter's next word to be equal to the current word we're checking
//        // increase number of words that the parameter has
//        if (lineData.word[i] != "AND" && lineData.word[i] != "xAND" && lineData.word[i] != "OR" && lineData.word[i] != "xOR"){
//
//            //tempLineData.word[paramNumWords] = lineData.word[i];
//            param[numParam].word[paramNumWords] = lineData.word[i];
//            paramNumWords++;
//            
//            //if this is the last word in the line....
//            if(i == (lineData.numWords - 1)){
//                param[numParam].numWords = paramNumWords;
//                 paramCondition[numParam].op = NONE;
//                numParam++;
//            }
//            
//        }
//            
//        // if the word is an AND or an OR, it must mean the last function has been completely identified
//        // set the parameters number of Words value to the calculated value
//        // increase the number of Parameters (the current parameter function we're filling)
//        else if (lineData.word[i].compare("AND") == 0 || lineData.word[i].compare("xAND") == 0 || lineData.word[i].compare("OR") == 0 || lineData.word[i].compare("xOR") == 0){
//            
//            //tempLineData.numWords = paramNumWords;
//            param[numParam].numWords = paramNumWords;
//            
//            paramCondition.push_back(ConditionOp());
//            if (lineData.word[i].compare("AND") == 0)
//                paramCondition[numParam].op = AND;
//            else if (lineData.word[i].compare("xAND") == 0)
//                paramCondition[numParam].op = xAND;
//            else if (lineData.word[i].compare("OR") == 0)
//                paramCondition[numParam].op = OR;
//            else if (lineData.word[i].compare("xOR") == 0)
//                paramCondition[numParam].op = xOR;
//
//            //param.push_back(LineData()); 
//            //param[numParam] = tempLineData;
//            //param.push_back(tempLineData); //add it to the vector list of parameters
//            //tempLineData = LineData(); //reset
//            numParam++; // increase the index of param
//            paramNumWords = 0; // reset the number of words
//        }    
//    }
//    
//
//    vector<ConditionOp> combinedCondition;
//    ConditionOp tempCombinedCondition;
//    int j = 0, k = 0;
//    for (j = 0; j < numParam; j++){
//        paramCondition[j].value = interpretCommand(selectedFile, param[j]);
//    }
//
//    //create the combined Condition vector (take care of this xAND and xOR statements and combine them into one so that the whole vector is just AND's and OR's)
//    //this should make the xAND's / xOR's into a single member of the combinedCondition vector
//    enum ConditionType prevCondition = NONE; 
//    int first = 1, last = 0;
//    for (k = 0; k < numParam; k++){
//
//        if (k == numParam - 1)
//            last = 1;
//            
//       if (!last){
//            if (paramCondition[k].op != xAND && paramCondition[k].op != xOR && paramCondition[k + 1].op != xAND && paramCondition[k + 1].op != xOR){
//                //AND
//                if (paramCondition[k].op == AND){
//                    if (!first && prevCondition != xAND && prevCondition != xOR)
//                        combinedCondition.back().value = combinedCondition.back().value && paramCondition[k + 1].value;
//                    else if (first || prevCondition == xAND || prevCondition == xOR){
//                        tempCombinedCondition.value = paramCondition[k].value && paramCondition[k + 1].value; 
//                        combinedCondition.push_back(tempCombinedCondition);
//                        first = 0;
//                    }    
//                    prevCondition = AND;
//                }
//                
//                //OR
//                else if (paramCondition[k].op == OR){
//                    if (!first && prevCondition != xAND && prevCondition != xOR)
//                        combinedCondition.back().value = combinedCondition.back().value || paramCondition[k + 1].value;
//                    else if (first || prevCondition == xAND || prevCondition == xOR){
//                        tempCombinedCondition.value = paramCondition[k].value || paramCondition[k + 1].value; 
//                        combinedCondition.push_back(tempCombinedCondition);
//                        first = 0;
//                    }    
//                    prevCondition = OR;
//                }
//            }
//            
//            // first value is something, not exclusive, but next values are exclusive
//            else if (first && (paramCondition[k].op == AND || paramCondition[k].op == OR) && (paramCondition[k + 1].op == xAND || paramCondition[k + 1].op == xOR)){
//                tempCombinedCondition.value = paramCondition[k].value;
//                tempCombinedCondition.op = paramCondition[k].op;
//                combinedCondition.push_back(tempCombinedCondition);
//                prevCondition = paramCondition[k].op;
//                first = 0;
//            }
//            
//            else{   
//                //xAND
//                if (paramCondition[k].op == xAND){
//                    if (combinedCondition.size() == 0){ // No values so start a new combinedCondition
//                        tempCombinedCondition.value = paramCondition[k].value && paramCondition[k + 1].value;
//                        tempCombinedCondition.op = xAND;
//                        combinedCondition.push_back(tempCombinedCondition);
//                        prevCondition = xAND;
//                    }
//                    else{
//                         if (combinedCondition.back().op == xAND){ // AND the value to the back most combinedCondition
//                            combinedCondition.back().value = combinedCondition.back().value && paramCondition[k + 1].value;
//                            prevCondition = xAND;
//                        }
//                        else if (combinedCondition.back().op != xAND){ // Start a new combinedCondition
//                            tempCombinedCondition.value = paramCondition[k].value && paramCondition[k + 1].value; 
//                            tempCombinedCondition.op = xAND;
//                            combinedCondition.push_back(tempCombinedCondition);
//                            prevCondition = xAND;
//                        }
//                    }
//                        
//                }
//                
//                //xOR
//                else if (paramCondition[k].op == xOR){
//                    if (combinedCondition.size() == 0){ // No values so start a new combinedCondition
//                        tempCombinedCondition.value = paramCondition[k].value || paramCondition[k + 1].value; 
//                        tempCombinedCondition.op = xOR;
//                        combinedCondition.push_back(tempCombinedCondition);
//                        prevCondition = xOR;
//                    }
//                    else{
//                         if (combinedCondition.back().op == xOR){ // OR the value to the back most combinedCondition
//                            combinedCondition.back().value = combinedCondition.back().value || paramCondition[k + 1].value;
//                            prevCondition = xOR;
//                        }
//                        else if (combinedCondition.back().op != xOR){ // Start a new combinedCondition
//                            tempCombinedCondition.value = paramCondition[k].value || paramCondition[k + 1].value; 
//                            tempCombinedCondition.op = xOR;
//                            combinedCondition.push_back(tempCombinedCondition);
//                            prevCondition = xOR;
//                        }
//                    }
//                        
//                }
//                
//                // Since the k + 1 value is included in the xAND or xOR exclusively, skip checking that value, and add the appropriate AND / OR as the
//                // operator of this exclusive xAND / xOR set
//                if ((paramCondition[k + 1].op == AND || paramCondition[k + 1].op == OR) && (prevCondition == xAND || prevCondition == xOR)){
//                    combinedCondition.back().op = paramCondition[k + 1].op;
//                    k++;
//                }
//                
//            }
//       }
//            
//        
//        // the last value was not included in any combination, since directly before the last value was an xAND / xOR set that
//        // included the very last AND / OR as the set's operator, yet there is still another value that has not been combined, as it is supposed
//        // to be AND /OR to the exclusive xAND / xOR set
//        else if (last && (prevCondition == xAND || prevCondition == xOR) && (combinedCondition.back().op == AND || combinedCondition.back().op == OR)){
//            tempCombinedCondition.value = paramCondition[k].value;
//            tempCombinedCondition.op = NONE; 
//            combinedCondition.push_back(tempCombinedCondition);
//        }
//        
//        //reset the tempCombinedCondition variable
//        tempCombinedCondition = ConditionOp();
//    }
//        
//                
//    // run through all values in the combined Condition vector, AND'ing / OR'ing as appropriate
//    // in the end, the last value in the array should be the final condition of the Condition statement... whether it was successful or failed
//    for (i = 0; i < (combinedCondition.size() - 1); i++){
//        if (combinedCondition[i].op == AND)
//            combinedCondition[i + 1].value = combinedCondition[i].value && combinedCondition[i + 1].value;
//        else if (combinedCondition[i].op == OR)
//            combinedCondition[i + 1].value = combinedCondition[i].value || combinedCondition[i + 1].value;
//    }
//
//    int conditionSuccess = combinedCondition.back().value; //value is the success(1) or failure(0) of the condition statement
//
//    int checkEnd = 0;
//    if (!conditionSuccess){
//
//        while (checkEnd != 4){
//            
//            getNextLine(selectedFile, lineData);
//            
//            // check if the first word is an end command (avoids interpreting functions that perform actions)
//            if (lineData.word[0].compare("end") == 0)   
//                checkEnd = interpretCommand(selectedFile, lineData);
//        
//            if (checkEnd == 4) // custom return value for this function
//                return 0;
//        }
//    }
//    
//    // Return success as the function either met the condition and will continue from the next line, or
//    // failed to meet the condition and ran through the lines inside the condition until "end condition" was found, therefore
//    // the program will proceed from the line after the "end condition" line
//    return 1;
//}   