#include "VoltageDriver.hpp"

//Constructor
VoltageDriver::VoltageDriver(LineData lineData){
    this->errorFlag = 0;
        
    //Order of Line: Command, Local_Name, VOLTAGE_DRIVER, Channel(1,2,3,4,5,6,7,8)
    if (lineData.numWords != 4)
        this->errorFlag = 1;
      
    string channelstr = lineData.word[3]; //Parameter is a number
    int numValuesFound = sscanf(channelstr.c_str(), "%d", &channel);
    if (numValuesFound < 1)
        this->errorFlag = 1;
        
    //Channel Value between 1 to 8
    if (channel >= 1 && channel <= 8){
        
        switch (channel){
            case 1:
            case 2:
                bridges.enablePwm(BridgeDriver::MOTOR_A, 0);
                break;
            case 3:
            case 4:
                bridges.enablePwm(BridgeDriver::MOTOR_B, 0);
                break;
            case 5:
            case 6:
                bridges.enablePwm(BridgeDriver::MOTOR_C, 0);
                break;
            case 7:
            case 8:
                bridges.enablePwm(BridgeDriver::MOTOR_D, 0);
                break;
        }    
    }
    
    //Channel does not fall into valid selection
    else
        this->errorFlag = 1;
}


int VoltageDriver::getChannel(){     
    return this->channel;
}


//A line consists of [ __(Local_Name)__ __(function)__ __(parameter1)__ __(parameter2)__ __(parameter3)__ ... and so on]
int VoltageDriver::interpret(LineData &lineData){

    //Order of line: local_name, function_name, param1, param2, param3,.......
    string func = lineData.word[1];
               
    /******************************************************************************/
    /***                       <func: forcebrake>                               ***/
    /******************************************************************************/
    if (func.compare("forcebrake") == 0){
        
        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        bridges.forceBrake(channel);
        
        //Record the settings for Pause and Resume
        currState = 0;
    }
    
    
    /******************************************************************************/
    /***                           <func: drive>                                ***/
    /******************************************************************************/
    else if (func.compare("drive") == 0){
        //order of line: local_name, drive

        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }

        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
 
        bridges.drive(channel, 1); //turn channel on

        //Record the settings for Pause and Resume
        currState = 1;
    }
    
    
    /******************************************************************************/
    /****                           <func: off>                                ****/
    /******************************************************************************/
    else if (func.compare("off") == 0){
        
        if (lineData.numWords != 2){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        off();
    }
    
    
    else {
        ErrorOut("Unknown Command for Voltage Driver Class", lineData.lineNumber);
        return -1;
    }  
            
    return 0; //Return success as 0 since no condition had to be met
}


//For stopping the entire system if an error occurs, can be called from main
int VoltageDriver::off(void){
    bridges.drive(getChannel(), 0); //turn channel off
    
    //Record the settings for Pause and Resume, and exit
    currState = 0;
    return 0;
}


//Stop the driver without changing the previous known settings, so that it will be saved on resume
int VoltageDriver::pause(void){
    bridges.drive(getChannel(), 0); //turn channel off
    return 0;
}

//Resume the driver using its previously known settings
int VoltageDriver::resume(void){
    bridges.drive(getChannel(), this->currState); //turn channel off
    return 0;
}

        
