#include "PinIN.hpp"
//#include "mbed.h"
//#include "LocalPinNames.h"
//#include "BridgeDriver.h"

//Constructor
PinIN::PinIN(LineData lineData){
    this->errorFlag = 0;
    
    //Order of Line: Command, Local_Name, PIN_IN, pinName, pinMode
    if (lineData.numWords != 5)
        this->errorFlag = 1;
        
    string _pinName = lineData.word[3]; // Local Pin
    string _pinMode = lineData.word[4]; // Pin Mode to Select
    
    if(_pinName.compare("DIO0") == 0)
        this->pinName = DIO0;
    else if(_pinName.compare("DIO1") == 0)
        this->pinName = DIO1;
    else if(_pinName.compare("DIO2") == 0)
        this->pinName = DIO2;
    else if(_pinName.compare("DIO3") == 0)
        this->pinName = DIO3;
    else if(_pinName.compare("DIO4") == 0)
        this->pinName = DIO4;
    else if(_pinName.compare("DIO5") == 0)
        this->pinName = DIO5;
    else if(_pinName.compare("DIO6") == 0)
        this->pinName = DIO6;
    else if(_pinName.compare("DIO7") == 0)
        this->pinName = DIO7;
    else if(_pinName.compare("DIO8") == 0)
        this->pinName = DIO8;
    else if(_pinName.compare("DIO9") == 0)
        this->pinName = DIO9;
    else if(_pinName.compare("DIO10") == 0)
        this->pinName = DIO10;
    else if(_pinName.compare("DIO11") == 0)
        this->pinName = DIO11;
        
    else if(_pinName.compare("AI0") == 0)
        this->pinName = AI0;
    else if(_pinName.compare("AI1") == 0)
        this->pinName = AI1;
    else if(_pinName.compare("AI2") == 0)
        this->pinName = AI2;
    else if(_pinName.compare("AI3") == 0)
        this->pinName = AI3;
    else if(_pinName.compare("AI4") == 0)
        this->pinName = AI4;
    else if(_pinName.compare("AI5") == 0)
        this->pinName = AI5;
    
    //Pin Name not recognized
    else
        this->errorFlag = 1;
        
    if(_pinMode.compare("PU") == 0)
        this->pinMode = PullUp;
    else if(_pinMode.compare("PD") == 0)
        this->pinMode = PullDown;
    else if(_pinMode.compare("PN") == 0)
        this->pinMode = PullNone;
    else if(_pinMode.compare("OD") == 0)
        this->pinMode = OpenDrain;
    
    //Pin Mode not recognized
    else
        this->errorFlag = 1;
}


//A line consists of [ __(Local_Name)__ __(function)__ __(parameter1)__ __(parameter2)__ __(parameter3)__ ... and so on]
int PinIN::interpret(LineData &lineData){
    
    //Initialize the Pin with appropriate values
    DigitalIn signal(pinName, pinMode);
    
    //Order of Line: Local_Name, Function_Name, Param1, Param2, Param3,.......
    string func = lineData.word[1];
        
    /******************************************************************************/
    /***                        <Func: wait>                               ***/
    /******************************************************************************/
    if (func.compare("wait") == 0){
        
        if (lineData.numWords != 3){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //Initialize and Convert Parameters
        string pinValue = lineData.word[2];
        int pinValue_Value = 0;
        
        int numValuesFound = sscanf(pinValue.c_str(), "%d", &pinValue_Value);
        if (numValuesFound < 1){
            ErrorOut("Parameter Unknown, pin value can't be converted", lineData.lineNumber);
            return -1;
        }
        
        if(pinValue_Value < 0 && pinValue_Value > 1){
            ErrorOut("Pin Value must be either 0 or 1", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        //Wait on the signal to turn to the specified value
        while(signal.read() != pinValue_Value);
    }
  
  
    /******************************************************************************/
    /***                            <Func: val>                                 ***/
    /******************************************************************************/
    // returns 1 if the check value is equal to the current check value of the Pin
    else if (func.compare("val") == 0){
        
        if (lineData.numWords != 3){
            ErrorOut("Incorrect number of parameters", lineData.lineNumber);
            return -1;
        }
        
        //Initialize and Convert Parameters
        string checkValue = lineData.word[2];
        int checkValue_Value = 0;
        int numValuesFound = sscanf(checkValue.c_str(), "%d", &checkValue_Value);
        if (numValuesFound < 1){
            ErrorOut("Parameter Unknown, pin value can't be converted", lineData.lineNumber);
            return -1;
        }
        
        if(checkValue_Value < 0 && checkValue_Value > 1){
            ErrorOut("Pin Value must be either 0 or 1", lineData.lineNumber);
            return -1;
        }
        
        //All syntax checking done by this point, if Dummy then return success in order to check the code, no need to perform functionality
        if (DummyMode)
            return 0; //Function operated successfully but doesn't return a value
            
        //Return one if value meets the wanted pin value, return 0 if it doesn't
        if(signal.read() == checkValue_Value){
            //Debounce check to ensure the value is still correct, if incorrect after debounce time, return 0, since it's a false truth
            if (signal.read() == checkValue_Value){
                Timer debounceTimer;
                debounceTimer.reset();
                debounceTimer.start();
                while (debounceTimer.read_ms() < 40);
                if (signal.read() == checkValue_Value)
                    return 1;
                else
                    return 0;
            }
        }
        else
            return 0;
    }
    
    else {
        ErrorOut("Unknown Command for PinIn Class", lineData.lineNumber);
        return -1;
    }  
            
    return 0; //Return success as 0 since no condition had to be met
}
