#ifndef TEXTFILE_HPP
#define TEXTFILE_HPP

#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string>
#include <stdlib.h>
#include <vector>
using std::string;

#include <iostream>
#include <istream>
#include <ostream>
#include <iterator>
#include <sstream>



//vector<string> filenames; //filenames are stored in a vector string

vector<string> readFileNames(char []);
int getFileNamesWithoutExt(string[], vector<string> &);
string getPreviousLine(istream &);



/******************************************************************************/
/***                           <readFileNames>                              ***/
/******************************************************************************/
// read file names into vector of strings
vector<string> readFileNames(char *dir) {
    
    vector<string> filenames;
    DIR *dp;
    struct dirent *dirp;
    

    dp = opendir(dir);
    
    //if no directory was found, don't try and get the fileNames and return an empty vector of 0
    if (dp != NULL){

        //read all directory and file names in current directory into filename vector
        while((dirp = readdir(dp)) != NULL) {
            filenames.push_back(string(dirp->d_name));
        }
        closedir(dp);
    }
    return filenames;
}



/******************************************************************************/
/***                      <getFileNamesWithoutExt>                          ***/
/******************************************************************************/
 // save filename strings to array from vector using an iterator
int getFileNamesWithoutExt(vector<string> &textFiles, vector<string> filenames) {
    
    //Cycle through all files listed in the directoy (strings in the vector list)
    int n = 0;
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++){
        
        vector<string> fileName; //filename[0] = filename, filename[1] = extension

        stringstream ss;
        ss << (*it);

        //parse the array based on a '.' delimeter, effectively getting the file name and extension
        string item;
        while (getline(ss, item, '.')) {
            fileName.push_back(item);
        }

        // if the fileName vector has two items (a name and an extension) and is a .txt file, then save it to the array
        if (fileName.size() == 2 && fileName[1].compare("txt") == 0) {  
            textFiles.push_back(fileName[0]);
            n++;
        }    
    }
    
    return n; //Return the number of txt files that were found in the directory   
}

/******************************************************************************/
/***                              <getNextLine>                             ***/
/******************************************************************************/
//

int getNextLine(FILE *selectedFile, LineData &lineData) {
    
    int validLine = 0;
    while (!validLine){
            
        lineData.lineAddress = ftell(selectedFile);
        
        if (lineData.lineAddress == -1L){
            ErrorOut("Unable to get address of line, SD Card Removed?", lineData.lineNumber + 1);
            return -1;
        }
        
        //char *newLine;
        //getline(selectedFile, newLine);
        char newLine[MAX_LINE_LENGTH];
        
        fgets(newLine, MAX_LINE_LENGTH, selectedFile);
        
        if (newLine == NULL){
            ErrorOut("Unable to get the next line, SD Card Removed?", lineData.lineNumber + 1);
            return -1;
        }
        
        lineData.lineNumber++; // new line successfully found, increase lineNumber      
        
        //pull out each individual word (separated by any white space), and place it in the vector
        stringstream newLineStrm(newLine);    
        istream_iterator<string> it(newLineStrm);
        istream_iterator<string> end;
        vector<string> results(it, end);
        
        //Get the size of the results vector, if it is 0 then while loop will loop again,
        //if it has a value, then it will accept the line and end looping cycles
        validLine = results.size();
    
        //copy the vector of results into the array of words
        copy(results.begin(), results.end(), lineData.word);
        
        lineData.numWords = results.size(); //Record the number of words in the line
        
        results.erase(results.begin(), results.end()); //remove the results vector from memory
    }
    
    //Update the Current Line Number
    lcd.setAddress(0,2);
    lcd.printf("Current Line#: %d ", lineData.lineNumber);
    
    //Update the cmd/dvc label for the line so that the user has an idea of what's going on
    lcd.setAddress(0,3);
    lcd.printf("                    "); // Clear the Line using Spaces (Emptyness) - Note one line is 20 Characters
    lcd.setAddress(0,3);
    lcd.printf("cmd/dvc: %s", lineData.word[0]);

    /*
    lcd.cls(); //clear the display   
    lcd.setAddress(0,0);
    lcd.printf("wrd1: %s", lineData.word[0]);
    lcd.setAddress(0,1);
    lcd.printf("wrd2: %s", lineData.word[1]);
    lcd.setAddress(0,2);
    lcd.printf("wrd3: %s", lineData.word[2]);
    lcd.setAddress(0,3);
    lcd.printf("wrd4: %s", lineData.word[3]);
    wait(1);*/
}


#endif 





