#ifndef INITIALIZATION_HPP
#define INITIALIZATION_HPP

#include "mbed.h"
#include "LocalPinNames.h"
#include "BridgeDriver.h"
#include "FrontPanelButtons.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include <string>
#include <vector>


/**********************************************************************************************************************************/
/**********************************************************************************************************************************/
/**************************                              <MUST MODIFY>                                    *************************/
/**********************************************************************************************************************************/
/**********************************************************************************************************************************/

enum  DeviceType{MOTOR, VOLTAGE_DRIVER, PIN_IN, TIMER_DEVICE, CAN_DEVICE};                                //ADD DEVICE NAME
static const enum DeviceType Device_Map[] = {MOTOR, VOLTAGE_DRIVER, PIN_IN, TIMER_DEVICE, CAN_DEVICE};    //AND HERE ***NOTE TO KEEP SAME ORDER

/**************************                              <MUST MODIFY>                                    *************************/
/**********************************************************************************************************************************/
/**********************************************************************************************************************************/



/******************************************************************************/
/***                       <Global Initializations>                         ***/
/******************************************************************************/

//Initializations
extern Timer timer;    // general purpose timer
extern I2C i2c; // I2C bus (SDA, SCL)
extern BridgeDriver bridges; // Bridge
extern TextLCD_I2C lcd; // LCD
extern SDFileSystem sd; // the pinout on the mbed LPC1768

extern DigitalIn killSw;

//extern Ticker errorWatcher;

extern const int MAX_LINE_LENGTH;
extern int DummyMode;
extern FILE *selectedFile;
extern int errorFLAG;

/******************************************************************************/
/***                 <Line Data Struct Initializations>                     ***/
/******************************************************************************/

struct LineData{
    
    int lineNumber;     //current line number in the program txt file that is running
    string word[50];    //array of words from the line of text, assuming no more than 50 words will be in any given line
                        //in this initialization there are 15 string (pointers) of size MAX_LINE_LENGTH each
    int numWords;       //Number of words in the given line
    int lineAddress;    //current line address in the SD Card
};

/******************************************************************************/
/***                     <Function Initializations>                         ***/
/******************************************************************************/

void fullInit(); //Perform and call any needed initializations
 
void initLCD(void); //Initialize the LCD

void ErrorOut(string, int); //Outputs error message, line number, and formatting to LCD

int cyclePrograms(vector<string>, int, int, int);

void resetLineData(LineData &); //reset and all variables of the Line Data Struct

int interpretCommand(LineData &);

int loopCommand(LineData &);

/******************************************************************************/
/***                     <GoTo Label Initializations>                       ***/
/******************************************************************************/

struct GoToLabel{

    string name;        //name of the GoTo Label
    int lineNumber;     //line number of the GoTo Label
    int lineAddress;    //line address of the GoTo Label
};

extern vector<GoToLabel> GoToLabels;


/******************************************************************************/
/***                   <Cycle Struct Initializations>                       ***/
/******************************************************************************/

struct CycleWatch{

    int numCycles;          //number of cycles to go to
    int counter;            //number the tracks the current cycle count
    float totalCycleTime;   //tracks the total amount of time for the cycle, in order to calculate the average cycle time
    int startAddress;       //starting address to seek back to on loop
    int startLineNumber;    //starting line number to reset to
};

/******************************************************************************/
/***              <Parent Device Class Initializations>                     ***/
/******************************************************************************/

extern const string DeviceNames[];
extern int numDevices;
extern int currNumDevices;


class Device{
    
    public:
        string name;
        int errorFlag;
        enum DeviceType type;
        static Device* newDevice(int, string, LineData);
        virtual int interpret(LineData&) = 0;
        virtual int off() = 0;
        virtual int pause() = 0;
        virtual int resume() = 0;
};

extern vector<Device*> devices; //Initialize vector of devices


/******************************************************************************/
/***                   <Error Monitor Initializations>                      ***/
/******************************************************************************/
/*
struct ErrorCondition{
    
    LineData errorToWatch;
    LineData errorFix;    
    int hasFix;
};

//extern vector<ErrorCondition> errorMonitors; //Initialize vector of errors to monitor
extern ErrorCondition errorMonitors[15];
extern int numErrorMonitors;*/
//void ErrorMonitor(); //Monitors the conditions to watch for erroring, and pauses system if any of the conditions turn out to be true

#endif