#include "Initialization.hpp"
#include "Motor.hpp"
#include "VoltageDriver.hpp"
#include "PinIN.hpp"
#include "TimerDevice.hpp"


/**********************************************************************************************************************************/
/**********************************************************************************************************************************/
/**************************                              <MUST MODIFY>                                    *************************/
/**********************************************************************************************************************************/
/**********************************************************************************************************************************/

// ADD YOUR DEVICE NAME THE \\EXACT SAME WAY\\ AS THE ENUM NAME YOU DECLARED IN THE.hpp
// Must Declare names in reverse order for some reason...., it's the way they're indexed I believe
const string DeviceNames[] = {"MOTOR", "VOLTAGE_DRIVER", "PIN_IN", "TIMER_DEVICE", "CAN_DEVICE"}; 

// ADD YOUR DEVICE TO THE LIST BELOW, CALLING YOUR DEVICE CLASS AS SHOWN
Device* Device::newDevice(int deviceFound, string _name, LineData lineData){
    
    switch (Device_Map[deviceFound]){
        case MOTOR:           return new Motor(lineData);          break;
        case VOLTAGE_DRIVER:  return new VoltageDriver(lineData);  break;
        case PIN_IN:          return new PinIN(lineData);          break;
        case TIMER_DEVICE:    return new TimerDevice(lineData);    break;
        
        //**********  ADD NEXT DEVICE ABOVE  **************//
        default:  break;
    }
}

/**************************                              <MUST MODIFY>                                    *************************/
/**********************************************************************************************************************************/
/**********************************************************************************************************************************/



/******************************************************************************/
/***                       <Global Initializations>                         ***/
/******************************************************************************/

//Initializations
Timer timer;    // general purpose timer
I2C i2c( P0_10, P0_11 ); // I2C bus (SDA, SCL)
BridgeDriver bridges(&i2c, 1); // Bridge
TextLCD_I2C lcd( &i2c, MCP23008_SA0, TextLCD::LCD20x4 ); // LCD
SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // the pinout on the mbed LPC1768

DigitalIn killSw(KILL, PullUp);

//Ticker errorWatcher;

const int MAX_LINE_LENGTH = 100;
int DummyMode = 0; // run through the code without performing actions
FILE *selectedFile;
int errorFLAG = 0;

vector<GoToLabel> GoToLabels; //Initialize vector of struct for GoTo Labels

/******************************************************************************/
/***                     <Function Initializations>                         ***/
/******************************************************************************/

void fullInit() {
    
    killSw.mode(PullUp);
    initLCD();     
    
    //Initialize the Error Watcher Interrupt / Ticker
    //errorWatcher.attach(&ErrorMonitor, 0.5);
    
}
 
void initLCD(void) {
    
    i2c.frequency(1000000);
    lcd.setBacklight(TextLCD::LightOn);
    wait(.6);
    lcd.cls(); //clear the display
    lcd.setAddress(0,0);
    lcd.printf("Initializing...");
}

void ErrorOut(string message, int lineNumber){
 
    lcd.cls(); //clear the display
    
    lcd.setAddress(0,0);
    lcd.printf("Error: %s", message);
    
    lcd.setAddress(0,3);
    lcd.printf("Line Number: %d", lineNumber);
}

/******************************************************************************/
/***              <Parent Device Class Initializations>                     ***/
/******************************************************************************/

int numDevices = sizeof(DeviceNames)/sizeof(DeviceNames[0]);
int currNumDevices = 0;

vector<Device*> devices; //create a vector to hold all of the devices


/******************************************************************************/
/***                   <Error Monitor Initializations>                      ***/
/******************************************************************************/

//vector<ErrorCondition> errorMonitors; //Initialize vector of errors to monitor
//ErrorCondition errorMonitors[15];
//int numErrorMonitors = 0;
/*
//Monitors the conditions to watch for erroring, and pauses system if any of the conditions turn out to be true
void ErrorMonitor(){ 
    
    int i = 0, error = -1, numError = 0;
    for(i = 0; i < errorMonitors.size(); i++){
        int checkCondition = 0;
        checkCondition = interpretCommand(errorMonitors[i].errorToWatch);
        
        //if Condition is true, that means the error occurred
        if (checkCondition == 1){
            numError++;
            
            //if the error has a Fix / Reset command, do it
            if (errorMonitors[i].hasFix){
                int returnValue;
                interpretCommand(errorMonitors[i].errorFix); //Fix / Reset the error based on how the user justified to do so
            }
                
            error = i; //Record index of error, will display only one error, but error will be last error that was true in the list
        }
    }
    
    if (numError){
        char errorMsg[100] = "Error Occurred!!!   Item: ";
        strcat(errorMsg, errorMonitors[error].errorToWatch.word[0].c_str()); //Send the first word of the error condition to help find out what the error was
        ErrorOut(errorMsg, numError);
        errorFLAG = 1; //set error flag equal to 1 if error occurred
    }
    else
        errorFLAG = 0; //set error flag equal to 0 if no errors occurred
        
}
*/

