#ifndef _UI_H_
#define _UI_H_

#include "MODSERIAL.h"

#define LED_ON 0

/**
 * User Interface.
 * LED display and Serial output.
 */
namespace ui
{
// Sample time
static const double kSampleTime = 0.5;

// UI states
enum State {
    IGNORE,
    STATE_SWITCHING,
    ROBOT_CONTROL
};

// UI state description
static const char *StateNames[] = {
    "Ignore user input",
    "State switching",
    "Control robot"
};

// Change state
void SwitchState(State new_state);

// Current state
extern State state;

// LEDs and Serial
extern DigitalOut rgb_led[];
extern MODSERIAL serial;

// Interrupt switches
void InterruptSwitch2();
void InterruptSwitch3();

// Display robot status through LEDs
void StatusDisplay();
}

#endif