#ifndef _REF_H_
#define _REF_H_

#include "robot.h"

/**
 * Reference signal generation.
 * Nte that currently no safety limits are implemented! One could simply use the
 * min/max x/y values as a check.
 */
namespace ref
{
// Sample time for reference signals
static const double kSampleTime = 0.01;

/**
 * Allowed range of motion and linear speed
 */
static const double kMinX = 0.280;  // [m]
static const double kMaxX = 0.560;  // [m]

static const double kMinY = -0.140; // [m]
static const double kMaxY =  0.170; // [m]

static const double kMaxSpeed = 0.05;                 // [m/s]
static const double kMaxStep = kMaxSpeed*kSampleTime; // [m]

/**
 * Calibration motion;
 */
static const double kCalibrationOmega = 20; // [deg/sec]
static const double kCalibrationError = 1;  // [deg]
static const double kCalibrationOmegaStep = kCalibrationOmega*kSampleTime; // [deg]


/**
 * Home angles
 */
static const double kOriginTheta1 = robot::InverseKinematicsTheta(kMinX,kMinY,1);//[deg]
static const double kOriginTheta2 = robot::InverseKinematicsTheta(kMinX,kMinY,2);


/**
 * Demo coordinates for linear movement between points
 */
extern int i_demo_coord;
static const int kNumDemoCoords = 9;
static const double kDemoCoords[2][kNumDemoCoords]  {
    {kMinX, kMaxX, kMaxX, kMinX, kMinX, kMaxX, kMaxX, kMinX, kMinX},
    {kMinY, kMinY, kMaxY, kMaxY, kMinY, kMaxY, kMinY, kMaxY, kMaxY}
};

/**
 * Current reference signal; motor angles and (x,y) through forward kinematics
 */
extern double theta_1;
extern double theta_2;

double get_ref_x();
double get_ref_y();

void SetPositionAsReference();

/**
 * Reference signal generation functions
 */
void UpdateReference();

void CalibrationReference();
void HomingReference();
void DemoReference();
}

#endif