/**
 * Code to bring BioRobotics2017 group 20's robot to life.
 *
 * M.E. Grootens, UTwente, v0.2 11-12-2017
 *
 * DISCLAIMER: 
 * Just a quick-and-dirty working-example. I do NOT claim this to be an
 * example of good coding practice... as it is not.
 * Motors and Controllers are implemented as C++ classes. Reference, UI and 
 * Robot are kept in different namespaces, so as to avoid too many global 
 * variables.
 *
 * THE PROGRAM:
 * The robot starts to calibrate when SW3 is pressed and will then cycle
 * through the following states:
 *
 * [OFF->CALIBRATION->HOMING->DEMO->OFF->CALIBRATION->etc.]
 *
 * The robot will move continuously; MANUAL mode is not implemented.
 */
#include "mbed.h"

#include "tools.h"
#include "ui.h"
#include "robot.h"
#include "ref.h"



/**
 * Main
 */
int main()
{
    // Start with only red LED
    ui::rgb_led[0] = LED_ON;
    ui::rgb_led[1] = !LED_ON;
    ui::rgb_led[2] = !LED_ON;

    // Setup serial comm
    ui::serial.baud(115200);
    ui::serial.printf("\r\n\r\n! STARTING MAIN LOOP.\r\n");
    ui::serial.printf("  - Initializing...\r\n");

    // Ignore user interface while setup, ensure robot is off
    ui::SwitchState(ui::IGNORE);
    robot::SwitchState(robot::OFF);

    // Tickers: status, control and reference signal
    Ticker tick_status;
    Ticker tick_control_loop;
    Ticker tick_reference;

    tick_status.attach(         &ui::StatusDisplay,     ui::kSampleTime);
    tick_control_loop.attach(&robot::ControlLoop,    robot::kSampleTime);
    tick_reference.attach(     &ref::UpdateReference,  ref::kSampleTime);

    // User input interrupt switches, pass to ui
    InterruptIn sw2(SW2);
    InterruptIn sw3(SW3);

    sw2.rise(ui::InterruptSwitch2);
    sw3.rise(ui::InterruptSwitch3);

    ui::serial.printf("  - Robot ready.\r\n");
    ui::SwitchState(ui::STATE_SWITCHING);

    // inf loop
    while (true);
}