#ifndef _CONTROLLER_H_
#define _CONTROLLER_H_


/**
 * PID Controller.
 * A moving average filter is applied to the input error; the lp-filtered input
 * is then used for a 1st-order velocity estimate for the D-part of the 
 * control signal.
 */
class Controller
{
public:
    // Constructor
    Controller(double kp, double ki, double kd,
        double t_sample, int memory_size=10);
    
    // Reset memory
    void Reset();

    // Update control output
    double Update(double e);

    // controller gaints get and set methods
    double get_kp() {return kp_;}
    double get_ki() {return ki_;}
    double get_kd() {return kd_;}

    void set_kp(double kp) {kp_ = kp;}
    void set_ki(double ki) {ki_ = ki;}
    void set_kd(double kd) {kd_ = kd;}

    // control memory get functions
    double get_e_p() {return e_p_;}
    double get_e_i() {return e_i_;}
    double get_e_d() {return e_d_;}

    double get_u() {return u_;}


private:

    // sample time for the controller
    const double kSampleTime_;

    // size of moving average memory
    const int kMemorySize_;

    // p,i,d, gains
    double kp_, ki_, kd_;

    // p,i,d errors
    double e_p_, e_i_, e_d_;

    // moving average memory and index of current value
    double *e_memory_;
    int i_memory_cur_;

    // moving average filtered error, current and previsou value for d action
    double e_p_avg_cur_;
    double e_p_avg_prev_;

    // control  signal
    double u_;
};

#endif
