#include "ui.h"
#include "robot.h"
/**
 * UI implementation
 */
namespace ui
{   
State state = IGNORE;

DigitalOut rgb_led[] {LED_RED, LED_GREEN, LED_BLUE};
MODSERIAL serial(USBTX,USBRX);

/**
 * Display robot state using (flashing) LEDs
 */
void StatusDisplay()
{
    switch (robot::state) {
        case robot::OFF: // continuous red;
            rgb_led[0] = LED_ON;
            rgb_led[1] = !LED_ON;
            rgb_led[2] = !LED_ON;
            break;
        case robot::CALIBRATION: // alternating red-green; busy
            rgb_led[0] = !rgb_led[0];
            rgb_led[1] = !rgb_led[0];
            rgb_led[2] = !LED_ON;
            break;
        case robot::HOMING: // alternating green-blue; busy
            rgb_led[0] = !LED_ON;
            rgb_led[1] = !rgb_led[1];
            rgb_led[2] = !rgb_led[1];
            break;
        case robot::READY: // continuous green
            rgb_led[0] = !LED_ON;
            rgb_led[1] = LED_ON;
            rgb_led[2] = !LED_ON;
            break;
        case robot::DEMO: // alternating red-blue; busy
            rgb_led[0] = !rgb_led[0];
            rgb_led[1] = !LED_ON;
            rgb_led[2] = !rgb_led[0];
            break;
        case robot::MANUAL: // alternating green-purple
            rgb_led[0] = !rgb_led[0];
            rgb_led[1] = !rgb_led[0];
            rgb_led[2] = rgb_led[0];
            break;
    }
}


/**
 * Switching UI state to a new state
 */
void SwitchState(State new_state)
{
    serial.printf("* Switching INPUT State to: %s\r\n",StateNames[new_state]);
    state = new_state;
}


void InterruptSwitch2()
{
    if (robot::has_power()) {
        robot::Stop();
    } else {
        robot::Start();
    }
}

void InterruptSwitch3()
{
    switch (state) {
        case STATE_SWITCHING:
            robot::GoToNextState();
            break;
    }
}

} // end namespace ui