#ifndef _ROBOT_H_
#define _ROBOT_H_

// GEAR RATIO AND ENCODER COUNTS
#define GEAR_RATIO       131
#define COUNTS_PER_REV   64

// Motor 1
#define M1_DIR              D7
#define M1_PWM              D6
#define M1_ENC_A            D10
#define M1_ENC_B            D11

// Motor 2
#define M2_DIR              D4
#define M2_PWM              D5
#define M2_ENC_A            D12
#define M2_ENC_B            D13

#include "motor.h"
#include "controller.h"



/**
 * Robot representation
 * Two motors, two motor controllers, forward & inverse kinematics.
 */
namespace robot
{
// sample time
static const double kSampleTime = 0.001;

// Robot states
enum State {
    OFF,
    CALIBRATION,
    HOMING,
    READY,
    DEMO,
    MANUAL
};

// Robot state description
static const char *StateNames[] = {
    "Off",
    "Calibration",
    "Homing",
    "Ready",
    "Demo",
    "Manual"
};

// State changing
void SwitchState(State new_state);
void GoToNextState();


/**
 * Robot properties
 */
static const double kL1 = 0.30;
static const double kL2 = 0.38;

static const double kCalibAngleMotor1 = 140;
static const double kCalibAngleMotor2 = -3;

/**
 * Motors and controllers
 */
extern Motor m1;
extern Motor m2;

extern Controller c1;
extern Controller c2;

/**
 * Robot state
 */
extern State state;
extern bool is_calibrated;

bool has_power();

double get_angle(int i);
double get_x();
double get_y();

/**
 * Forward and inverse kinematics
 */
double ForwardKinematicsX(double theta_1, double theta_2);
double ForwardKinematicsY(double theta_1, double theta_2);
double InverseKinematicsTheta(double x, double y, int i);

/**
 * Robot actions
 */
void Start();
void Stop();
void ControlLoop();

void SetCalibrationAngles();
}

#endif
