#ifndef _MOTOR_H_
#define _MOTOR_H_

#include "FastPWM.h"
#include "QEI.h"

// Very high-frequency PWM signal so as to cut out noise.
#define PWM_PERIOD_US 10

/**
 * Motor representation.
 * Speed (pwm); direction (dout); with QEI-encoder read-out.
 */
class Motor
{
public:
    /**
     * Constructor
     */
    Motor(PinName pwm, PinName dir, PinName enc_a, PinName enc_b,
          int pulses_per_rev, bool invert_dir = false);
    void Stop();
    void Start();
    
    bool has_power();
    
    void set_pwm(double pwm);


    double get_angle();
    void set_angle(double angle);

private:

    // Encoder, direction pin, pwm pin
    QEI encoder_;
    DigitalOut dir_;
    FastPWM speed_;

    // encoder/gear box constants
    const int kPulsesPerRev_;
    const bool kInvertDir_;

    // allowed to move
    bool power_;

    // internal offset s.t. the angle can be set.
    double offset_;

    // get encoder pulses; only for internal use
    int get_pulses();

};

#endif
