/**
 * Quick check to verify that indeed MODSERIAL is working again.
 */

#include "mbed.h"
#include "MODSERIAL.h"

#define SERIAL_BAUD 115200

MODSERIAL pc(USBTX,USBRX);
DigitalOut led(LED_RED);

// period with which Foo() is to be called
const float kPeriodFoo = 1.0f;

/**
 * Foo function.
 * @ensure foobar.
 */
void Foo()
{
    led = !led;
    pc.printf("led is %s\r\n",led?"OFF":"ON");
}

/**
 * Main function.
 */
int main()
{
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n**RESET**\r\n");
    
    Ticker tick_foo;
    tick_foo.attach(&Foo,kPeriodFoo);
    
    while (true);
}