/**
 * Minor BioRobotics 2016
 *
 * Programming Homework Set 2
 * Exercise 2, example solution.
 *
 * Note that this problem can be solved in *much* cleaner ways, using slightly 
 * more advanced C++ / programming techniques. However, this example shows that
 * even with very basic programming skills quite a lot can be achieved.
 *
 * M.E. Grootens [at] utwente.nl,
 * v0.1, 16.09.2016
 */

#include "mbed.h"

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = >
// Serial communication using MODSERIAL
#define SERIAL_BAUD 115200  // baud rate for serial communication
#include "MODSERIAL.h"
MODSERIAL pc(USBTX,USBRX);

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = >
// Timing
const float kTimeLedToggle = 0.25f; // period with which to toggle LED
const float kTimePrintSerial = 1.0f;// period with which data is printed

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = >
// constants
const int kNumLeds = 3;             // three LEDs
const int kLedOn = 0;               // LED on if 0

// LEDs
DigitalOut led_0(LED_RED);
DigitalOut led_1(LED_GREEN);
DigitalOut led_2(LED_BLUE);

// ID of led that should blink; *volatile* because changed by interrupt
volatile int led_blink_id = 0;

// counters
int num_turned_on_0 = 0;            // count number of times red LED turned on
int num_turned_on_1 = 0;            // count number of times green LED turned on
int num_turned_on_2 = 0;            // count number of times blue LED turned on



/**
 * Toggle / Switch / Blink the state of the LED.
 * Count the number of times the LED was turned ON.
 * We have quite some duplicate code here; this is not ideal and could be solved
 * using more 'advanced' concepts such as arrays and enums. 
 * However, this is outside the scope of this course for now.
 */
void ToggleLed()
{
    switch (led_blink_id) {
        case 0: {
            // LED 0 to toggle and count:
            led_0 = not led_0;
            if (led_0 == kLedOn) {
                num_turned_on_0++;
            }
            
            // LEDs to turn off:
            led_1 = not kLedOn;
            led_2 = not kLedOn;
            
            break;
        }
        case 1: {
            // LED 1 to toggle and count:
            led_1 = not led_1;
            if (led_1 == kLedOn) {
                num_turned_on_1++;
            }
            
            // LEDs to turn off:
            led_0 = not kLedOn;
            led_2 = not kLedOn;
            
            break;
        }
        case 2: {
            // LED 2 to toggle and count:
            led_2 = not led_2;
            if (led_2 == kLedOn) {
                num_turned_on_2++;
            }
            
            // LEDs to turn off:
            led_0 = not kLedOn;
            led_1 = not kLedOn;
            
            break;
        }
    }
}

/**
 * Print the number of times each LED was turned on through serial communication
 */
void PrintSerial()
{
    pc.printf("*Status*\r\n\tn_r = %d\r\n\tn_g = %d\r\n\tn_b = %d\r\n\r\n",
        num_turned_on_0, num_turned_on_1, num_turned_on_2);
}

/**
 * Switch the led id that blinks 
 * led_blink_id goes from 0 -> 1 -> 2 -> 0 -> ...
 * @ensure led_blink_id = ++led_blink_id % kNumStates
 */
void SwitchLedColor() {
    led_blink_id++;
    if (led_blink_id>=kNumLeds) {
        // could also use modulo ('%') operator
        led_blink_id = 0;
    } 
}

/**
 * Main loop.
 */
int main()
{
    // Serial comm baud rate
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n**RESET**\r\n");
    
    // Turn off all LEDs initially
    led_0 = not kLedOn;
    led_1 = not kLedOn;
    led_2 = not kLedOn;
    
    // Create ticker and attach LED toggle function
    Ticker tick_toggle_led;
    tick_toggle_led.attach(&ToggleLed,kTimeLedToggle);
    
    // Create ticker and attach Print function
    Ticker tick_print_serial;
    tick_print_serial.attach(&PrintSerial,kTimePrintSerial);
    
    // Create interrupt and attach switch function
    InterruptIn sw2(SW2);
    sw2.fall(&SwitchLedColor);
    
    while (true);
}
