/**
 * Minor BioRobotics 2016
 *
 * Programming Homework Set 2
 * Exercise 1, example solution
 *
 * M.E. Grootens [at] utwente.nl,
 * v0.1, 16.09.2016
 */

#include "mbed.h"
#include "MODSERIAL.h"

#define SERIAL_BAUD 115200  // baud rate for serial communication

// Serial communication using MODSERIAL
MODSERIAL pc(USBTX,USBRX);

// LED that is to blink
DigitalOut led_r(LED_RED);


const float kTimeLedToggle = 0.5f;  // period with which to toggle LED
const int kLedOn = 0;               // LED on if 0

int num_turned_on = 0;              // count number of times LED is turned on

/**
 * Toggle / Switch the state of the LED.
 * Count the number of times the LED was turned ON.
 */
void ToggleLed()
{
    led_r = not led_r;
    if (led_r == kLedOn) {
        num_turned_on++;
        pc.printf("LED has been turned on %d times\r\n",num_turned_on);
    }
}

/**
 * Main loop.
 */
int main()
{
    // Serial comm baud rate
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n**RESET**\r\n");
    
    // Turn off LED initially
    led_r = not kLedOn;
    
    // Create ticker and attach LED toggle function
    Ticker tick_toggle_led;
    tick_toggle_led.attach(&ToggleLed,kTimeLedToggle);
    
    while (true);
}
