/**
 * Minor BioRobotics 2016
 *
 * Programming Homework Set 1
 * Exercise 8, example solution
 *
 * M.E. Grootens [at] utwente.nl,
 * v0.1, 08.09.2016
 */

#include "mbed.h"

#define SERIAL_BAUD 115200  // baud rate for serial communication

// Serial communication with PC
Serial pc(USBTX,USBRX);

// The LED that is to flash
DigitalOut led(LED_RED);

// Number of times to flash; global and volatile, 'cause modified by interrupt
volatile int n_times = 0;

/**
 * Flash the LED
 * @ensure n_times is increased and then the LED flashes n_times
 */
void FlashLed()
{
    n_times++;
    
    pc.printf("\r\nFlashing %d times:\r\n",n_times);
    
    for (int i=0; i<n_times; i++) {
        pc.printf("[%d]",i);
        
        led.write(0);   // on
        wait(0.1f);     // wait 0.1 s
        led.write(1);   // off
        wait(0.4f);     // wait 0.4 s
    }
}


/**
 * Main function.
 */
int main()
{
    // Serial communication
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n**BOARD RESET**\r\n");
    
    // LED off
    led.write(1);
    
    // Interrupt; call FlashLed when button pressed
    InterruptIn sw2(SW2);
    sw2.fall(&FlashLed);
    
    // Infinite loop; does nothing but needs to prevent termination
    while (true);
}