#include "mbed.h"



#if 0

//******system clock and time functions test******

DigitalOut myled(PB_0);

int main()
{

// output on MCO1 pin 41 (PA8)
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_SYSCLK, RCC_MCODIV_1); // 24 MHz
//    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSE, RCC_MCODIV_1); // 8 MHz (xtal)
//    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_PLLCLK, RCC_MCODIV_1); // 12 MHz
//    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSI, RCC_MCODIV_1); // 8 MHz (RC gen)

    while(1) {
        myled = 1;
        wait(0.99);
        myled = 0;
        wait(0.01);
        myled = 1;
        wait(0.8);
        myled = 0;
        wait(0.2);
        myled = 1;
        HAL_Delay(1000);
    }
}
#endif




#if 0

//******stdio UART test******
// PA_2-TX; PA_3-RX

DigitalOut myled(PB_0);

int main()
{
    myled=0;
    printf("Hello World!\n");
    while(1) {
        printf("Heartbeat!\n");
        wait(1);
        myled=!myled;
    }
}
#endif



#if 0

//******DAC test******

#include <math.h>

AnalogOut dac1(PA_4);
AnalogOut dac2(PA_5);
int16_t k;
#define PI 3.14159265
#define SIN1_ARRAY_SIZE 500
uint16_t sin_data[SIN1_ARRAY_SIZE];

int main()
{
    for (k=0; k<SIN1_ARRAY_SIZE; k++) {
        sin_data[k]= (1.0+sin(1.0*k/SIN1_ARRAY_SIZE*2.0*PI))/2*0xFFFF;
    };

    k=0;
    while (1) {
        dac1.write_u16 (sin_data[k]);
        k++;
        if (k>=SIN1_ARRAY_SIZE) {
            k=0;
        };
        dac2.write_u16(1.0*0xFFFF*k/SIN1_ARRAY_SIZE);
        wait_us(25);
    }


}
#endif

#if 1

//******ADC test******
// adapted from https://developer.mbed.org/teams/ST/code/Nucleo_analog_loop/
// connect tested ADC input to PA_4

// serial output on pins where not adc option
Serial pc(PA_9, PA_10); // tx, rx

// test signal source
AnalogOut out(PA_4);


// select tested ADC input
#define ADC_IN 0


#if ADC_IN==0
AnalogIn in(PA_0);
const char pin_name[]="PA_0";
#elif ADC_IN==1
AnalogIn in(PA_1);
const char pin_name[]="PA_1";
#elif ADC_IN==2
AnalogIn in(PA_2);
const char pin_name[]="PA_2";
#elif ADC_IN==3
AnalogIn in(PA_3);
const char pin_name[]="PA_3";
#elif ADC_IN==4
AnalogIn in(PA_4);
const char pin_name[]="PA_4";
#elif ADC_IN==5
AnalogIn in(PA_5);
const char pin_name[]="PA_5";
#elif ADC_IN==6
AnalogIn in(PA_6);
const char pin_name[]="PA_6";
#elif ADC_IN==7
AnalogIn in(PA_7);
const char pin_name[]="PA_7";
#elif ADC_IN==8
AnalogIn in(PB_0);
const char pin_name[]="PB_0";
#elif ADC_IN==9
AnalogIn in(PB_1);
const char pin_name[]="PB_1";
#elif ADC_IN==10
AnalogIn in(PC_0);
const char pin_name[]="PC_0";
#elif ADC_IN==11
AnalogIn in(PC_1);
const char pin_name[]="PC_1";
#elif ADC_IN==12
AnalogIn in(PC_2);
const char pin_name[]="PC_2";
#elif ADC_IN==13
AnalogIn in(PC_3);
const char pin_name[]="PC_3";
#elif ADC_IN==14
AnalogIn in(PC_4);
const char pin_name[]="PC_4";
#elif ADC_IN==15
AnalogIn in(PC_5);
const char pin_name[]="PC_5";
#endif


int main()
{
    pc.printf("\nAnalog loop example\n");
    pc.printf("*** Connect %s and PA_4 pins together ***\n",pin_name);
    while(1) {
        for (float out_value = 0.0f; out_value <= 1.0f; out_value += 0.05f) {
            // Output value using DAC
            out.write(out_value);
            wait(0.1);
            // Read ADC input
            float in_value = in.read();
            // Display difference between two values
            float diff = out_value - in_value;
            pc.printf("(out:%.4f) - (in:%.4f) = (% .4f) ", out_value, in_value, diff);
            if (fabs(diff) > 0.03f) {
                pc.printf("FAIL\n");
            } else {
                pc.printf("OK\n");
                pc.printf("\033[1A"); // Moves cursor up of 1 line
            }
        }
    }
}



#endif
