//
// 5110 LCD Driver
// (c) 2012 @medvdv - Alexander Medvedev
//
 
//   
// Proportional font with 8px height 
// 

typedef struct {

    char first_code;
    char glyphs_total;   
    const char* widths;
    const char** glyphs;    
    
} lcd5110font;

// Contrast value depends of voltage and other factors 
#define DEFAULT_CONTRAST 30

//
// Nokia 5110 LCD Interface Class
//

class lcd5110 {

    // SPI and other pin's
    SPI* spi;
    DigitalOut* rst;
    DigitalOut* sce;
    DigitalOut* dc;

    // Current font    
    lcd5110font font;
    
    // Contrast value for next reset    
    char contrast;

    // Invert and bold flags 
    bool invert;
    bool bold;
    
    // current write position    
    int X, Y;
        
    // Generic SPI writer       
    void write(char byte, bool cmd = false);
            
    public:
    
    // Supply LCD connected pin's here for your design   
    lcd5110(PinName mosi= p11, PinName sclk = p13, PinName dc = p10, PinName sce = p8, PinName rst = p9);

    void Reset();                           // Reset LCD, configure defaults and contrast
    void Clear(char pattern = 0);           // Clear - fill all by 8bit line 'pattern'
    void Power(bool power = true);          // LCD power off / on
    void InverseMode(bool inverse = true);  // Inverse mode for all LCD

    void Contrast(char contrast = DEFAULT_CONTRAST );    // Change contrast
    
    void Invert(bool invert = true);        // Switch inverting of chars
    void Bold(bool bold = true);            // Switch bold mode (repeat each char row twice)
        
    void XY(int x = 0, int y = 0);          // Change write position X in pixels [0..83], Y in rows [0..5]
    
    // Row write
    void Write(char byte);                  // One 8bit row
    void Write(char byte, int count);       // One 8bit row * 'count' times
    void Write(char* data, int size);       // 'size' 8bit rows
    void Write2(char* data, int size);      // Bold: 'size' 8bit rows * 2   
    
    // Character drawing  
    void Character(char chr);               // Draw one font character (with invert and bold opt-s)
                                            // ! automaticaly does next line if char is wider then space left 
    int CharacterWidth(char chr);           // Calculate one character width (with bold opt-n)

    // String drawing
    void String(char* str);                 // Draw string proportionally
    int StringWidth(char* str);             // Calculate string width in px 
    
    void Row(int Y, char* str = "");        // Clear one text row and draw string on it

    ~lcd5110();                             // destruct pin's
    
}; 

