//
// MBED Application Board
// Lightweight Menu-driven Interface
// 2014, Alexander Medvedev, @medvdv
//

// 
// Menu entry types
//

#define APPMENU_NONE    0   // Empty row
#define APPMENU_ACTION  1   // Standart item - Text + action, returns id
#define APPMENU_BREAK   2   // Break line "----"
#define APPMENU_SUBMENU 3   // Enter to other menu
#define APPMENU_COMMENT 4   // Text comment, not active    
#define APPMENU_CHECK   5   // ->bool Check box, changes to true / false
#define APPMENU_RADIO   6   // ->int Radio button selection, changes to selected id
#define APPMENU_NUMBER  7   // ->int Changes number +/- as [minimum +step +2step ... maximum]
#define APPMENU_BAR     8   // ->float Progress bar level [0.0 .. 1.0]

// Padding from border in px

#define APPMENU_TAB     5

// Break entry line bits

#define APPMENU_DELIMITER   0x08

// 
// One menu entry: 
//

typedef struct {
    unsigned char type;         // APPMENU_* type     
    int id;                     // integer id for action, or radio button
    char * name;                // text name  
    bool bold;                  // draw it bold
    bool underline;             // underline it
    int minimum;                // minimum value for integer or progress
    int maximum;                // maximum value for integer or progress
    int step;                   // step for integer
    void * parameter;           // points to: int for progress, 
                                // int for radio button and integer number, 
                                // bool for checkbox, appMenuEntry for sub menu     
} lcd128entry;

// Menu interface - give it pointer to first entry from array and N of entrys 
// Returns id of action 
// Changes parameters of integer / progress entrys
// Selects checkboxes and radiobuttons
// Reopens other pointed menus
// Default pins assigment - for mbed application board joystick

int lcd128menu(lcd128 * lcd, lcd128entry * FirstEntry, int N, bool LastRow = true, 
            PinName pUp = p15, PinName pDown = p12, PinName pLeft = p13, PinName pRight = p16, 
            PinName pFire = p14); 