//
// MBED Application Board
// Lightweight Menu-driven Interface
// 2014, Alexander Medvedev, @medvdv
//

#include "mbed.h"

#include "lcd128lib.h"
#include "lcd128menu.h"

/*
#define APPMENU_END      0      // End of menu
#define APPMENU_ACTION   1      // Standart item - action
#define APPMENU_BREAK    2      // Break line "----"
#define APPMENU_SUBMENU  3      // Enter to other menu
#define APPMENU_COMMENT  4      // Text comment, not active    
#define APPMENU_CHECK    5      // Check box
#define APPMENU_RADIO    6      // One of radio buttons
#define APPMENU_NUMBER   7      // Integer number [minimum +step +2step ... maximum]
#define APPMENU_PROGRESS 8      // Float level [0.0 .. 1.0]
*/

#define APPMENU_WIDTH (LCD_X-APPMENU_TAB*2)

void lcd128draw(lcd128 * lcd, lcd128entry * entry, int row)
{
    lcd->XY(APPMENU_TAB, row);
    
    lcd->Bold(entry->bold);
    lcd->Underline(entry->underline);
    
    switch (entry->type) {
        case 0:
        default: 
            break;
        
        case 3:
            lcd->Character(LCD_PLAY);         
        case 1:
        case 4:
            lcd->String(entry->name); 
            break;
        
        case 2: 
            lcd->Write(APPMENU_DELIMITER, entry->bold ? APPMENU_WIDTH/2 : APPMENU_WIDTH ); 
            break; 
            
        case 5: 
            lcd->Character( ((bool*)entry->parameter)[0] ? LCD_CHECK_ON : LCD_CHECK_OFF );
            lcd->Character(LCD_SHORT_SPACE);
            lcd->String(entry->name); 
            break;

        case 6: 
            lcd->Character( (((int*)entry->parameter)[0] == entry->id) ? LCD_RADIO_ON : LCD_RADIO_OFF );
            lcd->Character(LCD_SHORT_SPACE);
            lcd->String(entry->name); 
            break;
            
        case 8:
            lcd->Bar(entry->bold ? APPMENU_WIDTH/2 : APPMENU_WIDTH, *(float*)entry->parameter);
            break;
    }

    lcd->Bold(false);
    lcd->Underline(false);
}

int lcd128menu(lcd128 * lcd, lcd128entry * menu, int N, bool LastRow, 
               PinName pUp, PinName pDown, PinName pLeft, PinName pRight, PinName pFire)
{
    if (N <= 0) return -1;
    
    BusIn joy(pUp, pDown, pLeft, pRight);
    DigitalIn fire(pFire);

    lcd128entry * menuCurrent = menu;
    int item = 0;    

    do {
            
        lcd -> Clear();
        
        lcd128draw(lcd, menuCurrent + item, 1);
                                        
        if (item > 0)     lcd128draw(lcd, menuCurrent + item - 1, 0);
        if (item < (N-1)) lcd128draw(lcd, menuCurrent + item + 1, 2);
        if (item < (N-2)) if (LastRow) lcd128draw(lcd, menuCurrent + item + 2, 3);
        
        lcd -> InverseRow(1);
        lcd -> InverseRow(0, 0x80);
        
        lcd -> Update();
        
        wait_ms(100);

        while((joy == 0) && (fire == 0)) wait_ms(100);
        
        if (joy & 1) if(item > 0) item--; 
        if (joy & 2) if(item < (N-1)) item++; 
                        
    } while(1);
}