#include "QT1070.h"

// Detection Status REG bits
#define QT1070_BIT_CALIB    7
#define QT1070_BIT_OVFLW    6
#define QT1070_BIT_TOUCH    0

// AVEAKS REG bits
#define QT1070_BIT_AVE      2

// FOMOGRD REG bits
#define QT1070_BIT_FO       5
#define QT1070_BIT_MAX_CAL  4
#define QT1070_MSL_GUARD    0xF0

QT1070::QT1070(I2C *i2c, PinName change):_i2c(i2c),_change(change){
    reset();
}

char QT1070::key(void){
    return read(REG_KEYSTAT);
}
 
bool QT1070::change(void){
    if(_change.is_connected()){
        return !_change;
    }else{
        return (read(REG_STATUS)&(1<<QT1070_BIT_TOUCH));
    }     
}

unsigned short QT1070::signal(char key){
    key%=KEY_NUM;
    return readW(REG_KEYSIG0+(key<<1));
}

unsigned short QT1070::ref(char key){
    key%=KEY_NUM;
    return readW(REG_REFDAT0+(key<<1));
}

char QT1070::nthresh(char key, char val){
    key%=KEY_NUM;
    if (val){
        write(REG_NTHR0+key,val);
    }
    return read(REG_NTHR0+key);
}

char QT1070::aksAve(char key, char group, char ave){
    key%=KEY_NUM;
    if(ave>AVEMAX)ave=AVEMAX;
    if(group>AKSMAX)group=AKSMAX;
    write(REG_AVEAKS0+key,(ave<<QT1070_BIT_AVE)|(group));
    return read(REG_AVEAKS0+key);
}

void QT1070::detectInt(char key, char val){
    key%=KEY_NUM;
    val |= 0x02;
    write(REG_DI0+key,val);
}

void QT1070::foMaxCal(bool fo, bool maxcal){
    char reg = read(REG_FOMOGRD);
    reg &= ~((1<<QT1070_BIT_FO) | (1<<QT1070_BIT_MAX_CAL));
    reg |= (fo<<QT1070_BIT_FO) | (maxcal<<QT1070_BIT_MAX_CAL);
    write(REG_FOMOGRD, reg);
}

void QT1070::guard(char key){
    key%=KEY_NUM;
    char reg = read(REG_FOMOGRD);
    reg &= QT1070_MSL_GUARD;
    reg |= key;
    write(REG_FOMOGRD ,reg);
}

void QT1070::lowpwr(unsigned short ms){
    if(ms>2040)ms=2040;
    char reg  = ms>>3;
    write(REG_LOWPWR, reg);
    
}

void QT1070::maxOnDuration(unsigned short ms){
     write(REG_MAXOND , ms>>4);
}

void QT1070::calibrate(void){
    write(REG_CALIB ,255);
}

void QT1070::reset(void){
    write(REG_RESET ,255);
}

void QT1070::write(char reg, char data){
    char buf[2] = {reg,data};
    _i2c->write(I2C_ADDR, buf, 2);
}

void QT1070::writeW(char reg, unsigned short data){
    char buf[3] = {reg,data>>8,data&0xff};
    _i2c->write(I2C_ADDR, buf, 3);
}

char QT1070::read(char reg){
    char ret;
    _i2c->write(I2C_ADDR, &reg, 1);
    _i2c->read(I2C_ADDR, &ret, 1);
    return ret;  
}

unsigned short QT1070::readW(char reg){
    char ret[2];
    _i2c->write(I2C_ADDR, &reg, 1);
    _i2c->read(I2C_ADDR, ret, 2);
    return ret[0]<<8 | ret[1];  
}

