#include "MCP9808.h"

//***********************************/************************************
//                              Constant                                //
//***********************************/************************************
#define MCP9808_I2C_ADDR    0x30 //( 18<<1)

#define MCP9808_REG_CONFIG  0x01
#define MCP9808_REG_TUPPER  0x02
#define MCP9808_REG_TLOWER  0x03
#define MCP9808_REG_TCRIT   0x04
#define MCP9808_REG_TAMB    0x05
#define MCP9808_REG_MANID   0x06
#define MCP9808_REG_DEVID   0x07
#define MCP9808_REG_RESOL   0x08

#define MCP9808_TAMB_MASK   0x0F
#define MCP9808_SIGN_POS    0x03

//***********************************/************************************
//                         Constructors                                 //
//***********************************/************************************
MCP9808::MCP9808(I2C *i2c, bool a0, bool a1, bool a2):_i2c(i2c)
{
    _addr = (MCP9808_I2C_ADDR | (a2<<3) | (a1<<2) | (a0<<1));
}

float MCP9808::getTemp(void)
{
    char reg = MCP9808_REG_TAMB;
    float ta;
    char buf[2];

    _i2c->write(_addr, &reg, 1);
    _i2c->read(_addr, buf, 2);
    
    /*
    if(buf[0] & (1<<MCP9808_SIGN_POS))
    {
        buf[0] &= MCP9808_TAMB_MASK;
        
        ta = 256 - (buf[0]*16 + buf[1]*0.0625); 
    }
    else
    {
        buf[0] &= MCP9808_TAMB_MASK;
        ta = (buf[0]*16 + buf[1]*0.0625);
    }*/
    
    ta = ((buf[0]&MCP9808_TAMB_MASK) << 8) | buf[1];
    ta /= 16.0;
    
    if(buf[0] & (1<<MCP9808_SIGN_POS))
    {
        ta -= 256;
    }
      
    return ta;  
}

