#ifndef MPC9808_H
#define MPC9808_H

#include "mbed.h"

/** MCP9808 class.
 *  Used for read MCP9808 ±0.5°C Maximum Accuracy Digital Temperature Sensor
 *
 * Example:
 * @code
 *#include "mbed.h"
 *#include "MCP9808.h"
 *
 *DigitalOut myled(LED1);
 *I2C i2cBus(D14,D15);
 *MCP9808 therm(&i2cBus, true, true, true);
 *
 *int main() 
 *{
 *   while(1) 
 *   {
 *       myled = !myled; // Toggle LED
 *       wait(0.2); // 200 ms
 *       printf("Temperature=%03.6f*C\r\n",therm.getTemp());
 *   }
 *}
 * @endcode
 */  
class MCP9808
{
    public:
        /** Create MCP9808 instance connected to I2C bus
        * @param *i2c I2C bus already initialized
        * @param a0 bool indicate a0 pin state to compute I2C address
        * @param a1 bool indicate a1 pin state to compute I2C address
        * @param a2 bool indicate a2 pin state to compute I2C address
        */
        MCP9808(I2C *i2c, bool a0=false, bool a1=false, bool a2=false);
        
        /**Get MCP9808 abient temperature
        * @returns temperature [°C]
        */    
        float getTemp(void);
        
#ifdef MBED_OPERATORS
    /** An operator shorthand for getTemp()
     *
     * The float() operator can be used as a shorthand for getTemp() to simplify common code sequences
     *
     * Example:
     * @code
     * float x = therm.getTemp();
     * float x = therm;
     *
     * if(therm.getTemp() > 20.25) { ... }
     * if(therm > 20.25) { ... }
     * @endcode
     */
    operator float(){return getTemp();}
#endif
              
    private:
        I2C *_i2c;
        int _addr;
};

#endif
