#include "MAX31855.h"

//***********************************/************************************
//                         Constructors                                 //
//***********************************/************************************
MAX31855::MAX31855(PinName mosi, PinName miso, PinName sck, PinName ncs) :_spi(mosi,miso,sck), _ncs(ncs)
{
    _ncs = 1;   //CS high
    _spi.format(8,0);
    _spi.frequency(1000000);
}

MAX31855::MAX31855(SPI& spi, PinName ncs) :_spi(spi), _ncs(ncs)
{
    _ncs = 1;   //CS high
    _spi.format(8,0);
    _spi.frequency(1000000);
}

//***********************************/************************************
//                                Get Set                               //
//***********************************/************************************
bool MAX31855::opened(void)
{
    read();
    return _oc;
}

bool MAX31855::fault(void)
{
    read();
    return _fault;
}

bool MAX31855::scToVcc(void)
{
    read();
    return _scv;
}

bool MAX31855::scToGnd(void)
{
    read();
    return _scg;
}



//***********************************/************************************
//                             Public Methods                           //
//***********************************/************************************
float MAX31855::thermocouple(void)
{
    read();
    return _t;
}

float MAX31855::chip(void)
{
    read();
    return _chip_t;
}
    
//***********************************/************************************
//                             Protected Methods                        //
//***********************************/************************************
void MAX31855::read(void)
{
    _ncs = 0;
    unsigned short high = ((_spi.write(0)<<8)&0xff00) + ((_spi.write(0)&0x00ff));
    unsigned short  low = ((_spi.write(0)<<8)&0xff00) + ((_spi.write(0)&0x00ff));
    _ncs = 1;
    
    _t = (high>>2)/4.0;
    _chip_t = (low>>4)/16.0;
    _fault = high&0x01;
    _scv = low&0x04;
    _scg = low&0x02;
    _oc = low&0x01;
    
}