#include "ADS1248.h"

#define ADS1248_HOLD_TIME_US        2

//***********************************/************************************
//                         Constructors                                 //
//***********************************/************************************
ADS1248::ADS1248(SPI& spi, PinName cs, PinName rdy, PinName start):_spi(spi),_cs(cs),_rdy(rdy),_start(start){
      
    _cs = 0;
    _start = 1; 
    _spi.format(8,1);
    wait(0.016);
    _cs = 1;
}

//***********************************/************************************
//                             Public Methods                           //
//***********************************/************************************ 
void ADS1248::start(bool en){
    _start = en;
}

void ADS1248::waitReady(void){
    while(!_rdy);
    while(_rdy);
}

void ADS1248::sleep(bool en){
    _start = 1;
    _cs = 0;
    _spi.write(en<<1);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
    waitReady();
}

void ADS1248::sync(void){
    _start = 1;  
    _cs = 0;
    _spi.write(SYNC);
    _spi.write(SYNC);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);   
}

void ADS1248::reset(void){
    _start = 1;  
    _cs = 0;
    _spi.write(RESET);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US); 
    wait_us(600);    
}


int ADS1248::read(void){
    int data;    
    _start = 1;
    waitReady();
    _cs = 0;
    _spi.write(RDATA);
    data = ((_spi.write(0)<<24)&0xFF000000);
    data |=((_spi.write(0)<<16)&0x00FF0000);
    data |=((_spi.write(0)<< 8)&0x0000FF00);
    data >>= 8;
    data &= 0xfffffff8;
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
    return data;
}

ADS1248::operator int(){
    return read();
}


void ADS1248::readReg(unsigned char reg, unsigned char *buff, int len){
    _start = 1;
    _cs = 0;
    _spi.write(RREG|(reg&0x0F));
    _spi.write(len-1);
    while(len--){
        *(buff++) = _spi.write(0);
    }
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
}

unsigned char ADS1248::readReg(unsigned char reg){
    unsigned char ret;
    readReg(reg,&ret,1);
    return ret;
}

void ADS1248::writeReg(unsigned char reg, const unsigned char *buff, int len){
    _start = 1;
    _cs = 0;
    _spi.write(WREG|(reg&0x0F));
    _spi.write(len-1);
    while(len--){
        _spi.write(*(buff++));
    }
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
}

void ADS1248::writeReg(unsigned char reg, unsigned char val){
    writeReg(reg,&val,1);
}

void ADS1248::systemOffsetCal(void){
    _start = 1;
    _cs = 0;
    _spi.write(SYSOCAL);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
    waitReady();
}

void ADS1248::systemGainCal(void){
    _start = 1;
    _cs = 0;
    _spi.write(SYSGCAL);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    wait_us(ADS1248_HOLD_TIME_US);
    waitReady();  
}

void ADS1248::selfOffsetCal(void){
    _start = 1;
    _cs = 0;
    _spi.write(SELFOCAL);
    wait_us(ADS1248_HOLD_TIME_US);
    _cs = 1;
    waitReady();
}

