#include "ADS1100.h"

#define ADS1100_DR_BIT  2
#define ADS1100_SC_BIT  4
#define ADS1100_ST_BIT  7
#define ADS1100_BSY_BIT 7

ADS1100::ADS1100(I2C* i2c, char ad):_i2c(i2c){
    _addr = I2C_ADDR | (ad<<1);
    config(false, 8, 1);
}

float ADS1100::read(float vdd){
    int max = -_minCode * _gain;
    return double(read_s16()) * vdd / double(max);
}

short ADS1100::read_s16(void){
    return readReg(&_config);
}

short ADS1100::readReg(char* config){
    char buf[3];
    _i2c->read(_addr,buf,3);
    *config = buf[2];
    return (buf[0]<<8) | (buf[1]&0xff);
}

void ADS1100::config(bool single, char rate, char gain){
    for(_config=0; _config<4; _config++){
        if(1==(gain>>_config)){
            break;
        }
    }
    switch (rate){
        case 128:
            _config |= 0 << ADS1100_DR_BIT;
            _minCode = -2048;
            break;
        case 32:
            _config |= 1 << ADS1100_DR_BIT;
            _minCode = -8192;
            break;
        case 16:
            _config |= 2 << ADS1100_DR_BIT;
            _minCode = -16384;
            break;
        case 8:
            _config |= 3 << ADS1100_DR_BIT;
            _minCode = -32768;
            break;
        default:
            _config |= 3 << ADS1100_DR_BIT;
            _minCode = -32768;
            break;
    };
    _config |= single << ADS1100_SC_BIT;
    _i2c->write(_addr, &_config, 1);
    _gain = gain;
}

void ADS1100::startConvert(void){
    _config |= 1<<ADS1100_BSY_BIT;
    _i2c->write(_addr, &_config, 1);
}

bool ADS1100::busy(void){
    readReg(&_config);
    return _config & (1<<ADS1100_BSY_BIT);
}
