#ifndef ADS1100_H
#define ADS1100_H

#include "mbed.h"

class ADS1100{
    
    public:
        enum state{
            I2C_ADDR = 0x90,    //I2C adress 
        };
        
        
        /** Create ADC1100 instance
        * @param *i2c initialized I2C bus to use
        * @param ad   <0,7> marking code number for addr
        */
        ADS1100(I2C* i2c, char ad);
        
        /** Read outputCode 
        * @return signed 16bit output code
        */
        short read_s16(void);
        
        /** Read output
        * @param vdd proportional factor defualt=1.0
        * @return vdd*code/codemax*gain
        */
        float read(float vdd=1.0);
        
        /** Configure ADS1100
        * @param single true for single converion mode false for continuous
        * @param rate can be 8,16,32,128 sample per sencods
        * @param gain can be 1,2,4,8
        */
        void config(bool single, char rate, char gain);
        
        /** Read registers
        * @param output cofig reg
        * @return s16 code
        */
        short readReg(char* config);
        
        /** Initiate a conversion (single mode)
        */
        void startConvert(void);
        
        /** Check if converstion finished (continuous mode)
        * @return bool true if busy
        */
        bool busy(void);
        
    private:
        I2C*    _i2c;
        char    _addr;
        char    _config;
        short   _minCode;
        char    _gain;
};

#endif
