#include "mbed.h"
#include "DS3231.h"
I2C i2c(I2C_SDA , I2C_SCL);
void DS3231_get(rtl *handle_rtl){
    char read_data[7];
    char reg = DS3231_TIME_SEC_ADDR;
    i2c.write(DS3231_SLA, &reg, 1);
    i2c.read(DS3231_SLA,read_data,7);
    handle_rtl->sec = SEC_BIT_TRM_GET(read_data[0]);
    handle_rtl->min = MIN_BIT_TRM_GET(read_data[1]);
    handle_rtl->hour = HOUR_BIT_TRM_GET(read_data[2]);
    handle_rtl->wday = WDAY_BIT_TRM_GET(read_data[3]);
    handle_rtl->day = DATE_BIT_TRM_GET(read_data[4]);
    handle_rtl->mon = MON_BIT_TRM_GET(read_data[5]);
    handle_rtl->year = YEAR_BIT_TRM_GET(read_data[6]);
}

void DS3231_init(rtl *handle_rtl){
    
    char init_data[8] = {0};
    
    init_data[0] = DS3231_TIME_SEC_ADDR;
    init_data[1] = SEC_BIT_TRM_SET(handle_rtl->sec);
    init_data[2] = MIN_BIT_TRM_SET(handle_rtl->min);
    init_data[3] = HOUR_BIT_TRM_SET(handle_rtl->hour);
    init_data[4] = WDAY_BIT_TRM_SET(handle_rtl->wday);
    init_data[5] = DATE_BIT_TRM_SET(handle_rtl->day);
    init_data[6] = MON_BIT_TRM_SET(handle_rtl->mon);
    init_data[7] = YEAR_BIT_TRM_SET(handle_rtl->year);
    i2c.write(DS3231_SLA, init_data, 8);
    
}
