// Control an R/C servo
// integer version
#include "mbed.h"
#define MIN_SERVO_PW_US 380
#define MAX_SERVO_PW_US 980
#define SERVO_PW_RANGE_US 600
#define SWEEP_INCR_DELAY 1000
#define SWEEP_DIR_DELAY 200

PwmOut servo(p21);

int main() {

    servo.period_ms(20);          // servo requires a 20ms period
    int offset_us = 0;
    
    while(1) {
        for(offset_us = 0; offset_us < SERVO_PW_RANGE_US; ++offset_us) {
            servo.pulsewidth_us(MIN_SERVO_PW_US + offset_us); // servo position determined by a pulsewidth between 0.38-0.98ms (380 - 980us)
            wait_ms(SWEEP_INCR_DELAY); // wait for 100ms
        }

        wait_ms(SWEEP_DIR_DELAY); // wait for 1sec before doing a reverse sweep

        for(; offset_us > 0; --offset_us) {
            servo.pulsewidth_us(MIN_SERVO_PW_US + offset_us); // servo position determined by a pulsewidth between 0.38-0.98ms (380 - 980us)
            wait_ms(SWEEP_INCR_DELAY); // wait for 100ms
        }
        wait_ms(SWEEP_DIR_DELAY); // wait for 1sec before doing a reverse sweepwait_ms(1000); // wait for 1sec before doing a reverse sweep
    }
}
