#include "mbed.h"
#include "xbee.h"
#include "ultrasonic.h"
#include "hcsr04.h"

//sonars
HCSR04  front1(p13,p12);
HCSR04  front2(p14,p12);
HCSR04  back1(p15,p12);
HCSR04  back2(p16,p12);

//IR sensors
InterruptIn PIR_Left(p17);
InterruptIn PIR_Right(p18);

//SHOWING SENDING STATUS
BusOUT sending(LED1,LED2,LED3,LED4);

xbee xbee1(p9,p10,p11); //Initalise xbee_lib
Serial pc(USBTX, USBRX); //Initalise PC serial comms

int main()
{
    char send_data[202]; //Xbee buffer size is 202 bytes
    char read_data[202]; //Xbee buffer size is 202 bytes

    while(1) {
        pc.scanf("%s",send_data); //Read data from serial console
        xbee1.SendData(send_data); //Send data to XBee
        xbee1.RecieveData(read_data,0); //Read data from the XBee
        pc.printf("You said:%s",read_data);
    }
}
