/* * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is a stepper motor library for testing       *
 * 4 step stepper motors.  The speed of stepping is  *
 * variable as well as the amount of steps.          *
 * ------------------------------------------------- *
 * This library is based on the sMotor library by    *
 * Samuel Matildes (sam.naeec@gmail.com).            *
 * ------------------------------------------------- *
 *                                                   *
 * Created by: Michael Dushkoff (mad1841@rit.edu)    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef MBED_MSTEPMOTOR_H
#define MBED_MSTEPMOTOR_H
 
#include "mbed.h"

class mMotor {
public:

    mMotor(PinName M0, PinName M1, PinName M2, PinName M3); //motor constructor

    /* Low Torque mode */
    void step(int num_steps, int direction, int speed);
    void counterclockwise();
    void clockwise();
    
    /* High Torque mode */
    void ht_step(int num_steps, int direction, int speed);
    void ht_counterclockwise();
    void ht_clockwise();


private:

    DigitalOut _M0;
    DigitalOut _M1;
    DigitalOut _M2;
    DigitalOut _M3;

};

#endif