/* * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is a stepper motor library for testing       *
 * 4 step stepper motors.  The speed of stepping is  *
 * variable as well as the amount of steps.          *
 * ------------------------------------------------- *
 * This library is based on the sMotor library by    *
 * Samuel Matildes (sam.naeec@gmail.com).            *
 * ------------------------------------------------- *
 *                                                   *
 * Created by: Michael Dushkoff (mad1841@rit.edu)    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "mbed.h"
#include "mMotor.h"

int motorSpeed; // Steper speed

mMotor::mMotor(PinName M0, PinName M1, PinName M2, PinName M3) : _M0(M0), _M1(M1), _M2(M2), _M3(M3) { // Defenition of motor pins
    _M0=0;
    _M1=0;
    _M2=0;
    _M3=0;
}


void mMotor::counterclockwise() { // rotate the motor 1 step anticlockwise 
    for (int i = 0; i < 4; i++) {
        switch (i) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                _M0=0;
                _M1=0;
                _M2=0;
                _M3=1;
            }
            break;
            case 1: {
                _M0=0;
                _M1=0;
                _M2=1;
                _M3=0;
            }
            break;
            case 2: {
                _M0=0;
                _M1=1;
                _M2=0;
                _M3=0;
            }
            break;
            case 3: {
                _M0=1;
                _M1=0;
                _M2=0;
                _M3=0;
            }
            break;
        }

        wait_us(motorSpeed); // wait time defines the speed 
    }
    _M0 = 0;
    _M1 = 0;
    _M2 = 0;
    _M3 = 0;
}

void mMotor::clockwise() { // rotate the motor 1 step clockwise 
    for (int i = 0; i < 4; i++) {
        switch (i) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                _M0=1;
                _M1=0;
                _M2=0;
                _M3=0;
            }
            break;
            case 1: {
                _M0=0;
                _M1=1;
                _M2=0;
                _M3=0;
            }
            break;
            case 2: {
                _M0=0;
                _M1=0;
                _M2=1;
                _M3=0;
            }
            break;
            case 3: {
                _M0=0;
                _M1=0;
                _M2=0;
                _M3=1;
            }
            break;
        }

        wait_us(motorSpeed); // wait time defines the speed 
    }
    _M0 = 0;
    _M1 = 0;
    _M2 = 0;
    _M3 = 1;
}

void mMotor::ht_clockwise() { // rotate the motor 1 step clockwise 
    for (int i = 0; i < 4; i++) {
        switch (i) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                _M0=1;
                _M1=0;
                _M2=0;
                _M3=0;
            }
            break;
            case 1: {
                _M0=0;
                _M1=1;
                _M2=0;
                _M3=0;
            }
            break;
            case 2: {
                _M0=0;
                _M1=0;
                _M2=1;
                _M3=0;
            }
            break;
            case 3: {
                _M0=0;
                _M1=0;
                _M2=0;
                _M3=1;
            }
            break;
        }

        wait_us(motorSpeed); // wait time defines the speed 
    }
}

void mMotor::ht_counterclockwise() { // rotate the motor 1 step anticlockwise 
    for (int i = 0; i < 4; i++) {
        switch (i) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                _M0=0;
                _M1=0;
                _M2=0;
                _M3=1;
            }
            break;
            case 1: {
                _M0=0;
                _M1=0;
                _M2=1;
                _M3=0;
            }
            break;
            case 2: {
                _M0=0;
                _M1=1;
                _M2=0;
                _M3=0;
            }
            break;
            case 3: {
                _M0=1;
                _M1=0;
                _M2=0;
                _M3=0;
            }
            break;
        }

        wait_us(motorSpeed); // wait time defines the speed 
    }
}


void mMotor::step(int num_steps, int direction, int speed) {// steper function: number of steps, direction (0- right, 1- left), speed (default 1200)
    int count=0; // initalize step count
    motorSpeed=speed; //set motor speed
    if (direction==0) // turn clockwise
        do {
            clockwise();
            count++;
        } while (count<num_steps); // turn number of steps applied 
    else if (direction==1)// turn anticlockwise
        do {
            counterclockwise();
            count++;
        } while (count<num_steps);// turn number of steps applied 

}

void mMotor::ht_step(int num_steps, int direction, int speed) {// steper function: number of steps, direction (0- right, 1- left), speed (default 1200)
    int count=0; // initalize step count
    motorSpeed=speed; //set motor speed
    if (direction==0) // turn clockwise
        do {
            ht_clockwise();
            count++;
        } while (count<num_steps); // turn number of steps applied 
    else if (direction==1)// turn anticlockwise
        do {
            ht_counterclockwise();
            count++;
        } while (count<num_steps);// turn number of steps applied 

}