/* * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This times a race with up to two separate timers  *
 * which start whenever a button press interrupt is  *
 * detected.  The timers are stopped only by         *
 * recording a tripwire interrupt which will save    *
 * the time and output it to the serial port.        *
 *                                                   *
 * Created by: Michael Dushkoff (mad1841@rit.edu)    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * */
 
#include "mbed.h"
#include "mMotor.h"

/* Stepper motor constants, (change based on motor) */
int step_speed = 5000; // set default motor speed 4000 (fast) 5000 (natural)
int numstep1 = 30; // Defines rising turn (200)
int numstep2 = 30;  // Defines falling turn (20)

DigitalOut txo(p30);  //Defines the transmit pin output

/* Create two stepper motor controllers */
mMotor mt1(p33, p34, p35, p36);
mMotor mt2(p11, p12, p13, p14);

/* Create two individual timers */
Timer t1;
Timer t2;

/* Interrupt sensors */
InterruptIn bInt1(p23);
InterruptIn bInt2(p24);

/* Indicator LEDs */
DigitalOut iled1(LED1);
DigitalOut iled2(LED4);
DigitalOut tled1(LED2); //Timer LED1
DigitalOut tled2(LED3); //Timer LED2

/* Tells when to stop the timer */
int end1 = 0;
int end2 = 0;

/* This is a print button that allows the time to be outputted */
DigitalIn button(p8);

/* Rise detection */
int rise = 0;

/* Setup detection */
int setup = 1;

void transmit(){
    txo = 0;
    wait(0.01);
    txo = 1;
    wait(0.01);
    txo = 0;
    wait(0.01);
    txo = 1;
}

/* This detects button interrupt 1 */
void b1(){
    if (setup == 0){
        mt1.step(numstep2,0,step_speed);
        transmit();
        setup = 1;
    }
}

/* This detects button interrupt 2 */
void b2(){
    if (setup == 1){
        mt1.step(numstep1,1,step_speed);
        setup = 0;
    }
}

int main() {
    /* Drive transmit pin */
    txo = 1;
    
    /* Put into setup mode */
    setup = 1;
    
    /* Turn LEDs on */
    iled1 = 1;
    iled2 = 1;
    tled1 = 1;
    tled2 = 1;
    
    printf("Starting up...\n\r");
    
    /* Attach interrupt service routine to pins */
    bInt1.rise(&b1);
    bInt2.rise(&b2);
    
    /* Set the LEDs off */
    iled1 = 0;
    iled2 = 0;
    tled1 = 0;
    tled2 = 0;
    
    setup = 1;
    
    printf("Ready!\n\r");
    while(1) {
        // Do nothing
    }
}
