/* * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This detects a winner in a two person race by     *
 * detecting when there is a break in the signal     *
 * sent to two different pins.  When the winner is   *
 * detected, the corresponding LED is lit.           *
 *                                                   *
 * Created by: Michael Dushkoff (mad1841@rit.edu)    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * */
#include "mbed.h"

/* This is a print button that allows the time to be outputted */
DigitalIn button(p30);

/* Tells when to stop the timer */
int end1 = 0;
int end2 = 0;

/* Rise detection */
int rise = 0;

/* Create two individual timers */
Timer t1;
Timer t2;

/* Recieving pin */
InterruptIn rxo(p10);

/* Interrupt sensors */
InterruptIn sEnd1(p20);
InterruptIn sEnd2(p21);

/* Indicator LEDs */
DigitalOut iled1(p22);
DigitalOut iled2(p23);

/* Status LEDs */
DigitalOut sled1(LED1);
DigitalOut sled2(LED2);
DigitalOut sled3(LED3);
DigitalOut sled4(LED4);

/* Winner LEDs */
DigitalOut wled11(p11);  // Gate 1 Win
DigitalOut wled12(p12);  // Gate 1 Win
DigitalOut wled13(p13);  // Gate 1 Win
DigitalOut wled21(p36);  // Gate 2 Win
DigitalOut wled22(p35);  // Gate 2 Win
DigitalOut wled23(p34);  // Gate 2 Win

/* Tells when there is a winner */
int win = 0;

/* Pulsed recieving */
int rxc = 0;

/* This detects a transmitted signal */
void recieve(){
    if (rxc >= 1){
        /* Set status LEDs */
        sled2 = 1;
        sled3 = 1;
        
        /* Start timers */
        t1.start();
        t2.start();
    }
    rxc += 1;
}

/* This detects interrupt 1 */
void l1(){
    if (win == 0){
        iled1 = 1;
        win = 1;
        wled11 = 1;
        wled12 = 1;
        wled13 = 1;
    }
    end1 = 1;
    sled1 = 1;  // Set status LED
    t1.stop();  // Stop timer 1
}

/* This detects interrupt 2 */
void l2(){
    if (win == 0){
        iled2 = 1;
        win = 1;
        wled21 = 1;
        wled22 = 1;
        wled23 = 1;
    }
    end2 = 1;
    sled4 = 1;  // Set status LED
    t2.stop();  // Stop timer 2
}

int main() {
    /* Set the LEDs off */
    iled1 = 0;
    iled2 = 0;
    sled1 = 0;
    sled2 = 0;
    sled3 = 0;
    sled4 = 0;
    wled11 = 0;
    wled12 = 0;
    wled13 = 0;
    wled21 = 0;
    wled22 = 0;
    wled23 = 0;
    
    /* Attach interrupt service routine to pins */
    sEnd1.fall(&l1);
    sEnd2.fall(&l2);
    rxo.rise(&recieve);
    
    printf("Ready!\n\r");
    while(1) {
        if (button.read() == 1 && rise == 0){
            /* Set rise detector to high */
            rise = 1;
            
            /* Check Track 1 */
            if (end1 == 1){
                printf("========== Track 1 Time ==========\n\r");
                printf(" Finished in: %lf seconds\n\r", t1.read());
                printf("==================================\n\r\n\r"); 
            }
            else {
                printf("Track 1 has not finished\n\r\n\r");   
            }
            
            /* Check Track 2 */
            if (end2 == 1){
                printf("========== Track 2 Time ==========\n\r");
                printf(" Finished in: %lf seconds\n\r", t2.read());
                printf("==================================\n\r\n\r"); 
            }
            else {
                printf("Track 2 has not finished\n\r\n\r");   
            }
        }
        else if (button.read() == 0 && rise == 1){
            /* Reset rise detection */
            rise = 2;
            wait (0.001); //Debounce
        }
        else if (button.read() == 0 && rise == 2){
            rise = 0;
        }
    }
}
