/*
 * e-Paper control program
 * MODIFIED by Mark Roberts for the Waveshare 2.7inch Pi Hat
 * Tested on Nucleo L432KC with pins as defined below...
 * https://www.waveshare.com/wiki/2.7inch_e-Paper_HAT?spm=a2g0o.detail.1000023.17.1e014701V7d4HU&file=2.7inch_e-Paper_HAT
 *
 * Copyright (c) 2019 Kenji Arai / JH1PJL
 *  http://www.page.sannet.ne.jp/kenjia/index.html
 *  http://mbed.org/users/kenjiArai/
 *      Created:    April     27th, 2019
 *      Revised:    June      29th, 2019
 *
 *  Tested on Nucleo-F446RE with mbed-os5.12.2
 *
 *  Refrence software
 *  https://github.com/waveshare/e-Paper
 *  https://os.mbed.com/users/imachooon/code/epd1in54/
 *          Thanks imamura-san
 *
 *  Technical documents
 *  https://www.waveshare.com/wiki/2.13inch_e-Paper_HAT_(B)
 *
 *  Product
 *  http://akizukidenshi.com/catalog/g/gP-13757/
 *  https://www.waveshare.com/2.13inch-e-paper-hat-b.htm
 */

//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "epd2in7b.h"
#include "epdpaint.h"

//  Definition -----------------------------------------------------------------
#define COLORED     0
#define UNCOLORED   1

//  Constructor ----------------------------------------------------------------
//  3.3V, GND, DIN,     ,  CLK,  CS, DC, RST, BUSY,   <- 2.13inch e-Paper pin   
//            mosi, miso, sclk,  cs, dc, rst, busy, pwr
Epd epd = Epd(  PB_5,   NC,   PB_3, PA_11, PA_0,  PA_12,   PA_1,  NC);  // modified for NUCLEO_L432KC

Serial pc(USBTX, USBRX);
Timer t;
static int timeSet = 0;

//  RAM ------------------------------------------------------------------------
uint8_t image[EPD_VERT*(EPD_HORIZ/8 + 1)];

//  ROM / Constant data --------------------------------------------------------

//  Function prototypes --------------------------------------------------------
extern void time_enter_mode(void);

//------------------------------------------------------------------------------
//  Control Program
//------------------------------------------------------------------------------
int main()
{
    time_t seconds;
    char buf[32];

    t.reset();
    t.start();
/*
    if (timeSet == 0) {  // if time not set then go to time enter mode
        time_enter_mode();
	timeSet = 1;
    }
*/
    seconds = time(NULL);   // read current time
    if (epd.Init() != 0) {  // initialize e-Paper control program
        printf("e-Paper init failed");
        return -1;
    }
    epd.ClearFrame();
    printf("Clear Frame completed\r\n");
    ThisThread::sleep_for(200);
    Paint paint(image, EPD_HORIZ, EPD_VERT);
    paint.Clear(UNCOLORED);   
    printf("Clear uncolored 1 complete\r\n");

    paint.SetRotate(ROTATE_90);
    paint.DrawStringAt(0,  4,  "12345678901234567890123456789",
                       &Font8, COLORED);
    paint.DrawStringAt(0,  16,  "12345678901234567890123456789",
                       &Font12, COLORED);
    paint.DrawStringAt(0,  32,  "12345678901234567890123",
                       &Font16, COLORED);
    paint.DrawStringAt(0,  54,  "123456789012345678",
                       &Font20, COLORED);
    paint.DrawStringAt(0,  80,  "123456789012345",
                       &Font24, COLORED);
    paint.DrawStringAt(0, 110, "Waveshare 2.7 e-Paper WBR",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 124, "   tested on Nucleo-L432KC",
                       &Font12, COLORED);
    paint.DrawStringAt(0, 138, "      by mdroberts1243 ",
                       &Font12, COLORED);
    strftime(buf, 30, "'%y-%m-%d %H:%M", localtime(&seconds));
    paint.DrawStringAt(0, 160, buf, &Font16, COLORED);
    printf("Text paint buffer rendered\r\n");

    epd.SetPartialWindowBlack(paint.GetImage(), 0, 8,
                              paint.GetWidth(), paint.GetHeight());
    printf("SetPartialWindowBlack\r\n");

    paint.Clear(UNCOLORED);
    printf("Clear uncolored 2 complete\r\n");
    paint.SetRotate(ROTATE_90);
    paint.DrawFilledRectangle(0, 150, 250, 156, COLORED);
    printf("Filled rectangle\r\n");
    paint.DrawFilledCircle(244, 150, 18, COLORED);
    printf("Filled circle\r\n");
    epd.SetPartialWindowRed(paint.GetImage(), 0, 8,
                               paint.GetWidth(), paint.GetHeight());
    printf("SetPartialWindowRed\r\n");

    epd.DisplayFrame();
    printf("DisplayFrame\r\n");

    epd.Sleep();

    strftime(buf, 30, " %B %d,'%y, %H:%M:%S", localtime(&seconds));
    pc.puts(buf);
    pc.printf("  Display + Refresh time = %5.1f Sec\r\n", t.read());
    ThisThread::sleep_for((1000 * 60 * 1) - t.read_ms());   // sleep 1 minute
    system_reset(); // restart
}
